package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.types.{ UnionTypeNode, WeaveTypeNode }

object UnionTypeNodeSerializer extends AstNodeSerializer[UnionTypeNode] {

  override protected def doSerialize(node: UnionTypeNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val of = AstToSerializableMapper.serializeSeq(node.of)
    val maybeSchema = SchemaNodeSerializer.serializeMaybe(node.maybeSchema)
    val maybeTypeSchema = SchemaNodeSerializer.serializeMaybe(node.maybeTypeSchema)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, of, maybeSchema, maybeTypeSchema, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.UNION_TYPE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): UnionTypeNode = {
    val of = AstToSerializableMapper.deserializeSeq(children.head, context).asInstanceOf[Seq[WeaveTypeNode]]
    val maybeSchema = SchemaNodeSerializer.deserializeMaybe(children(1), context)
    val maybeTypeSchema = SchemaNodeSerializer.deserializeMaybe(children(2), context)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(3), context)
    UnionTypeNode(of, maybeSchema, maybeTypeSchema, annotations)
  }
}
