package org.mule.weave.v2.compilation.message

import org.mule.weave.v2.parser.Message
import org.mule.weave.v2.parser.MessageCategory
import org.mule.weave.v2.parser.MessageKind
import org.mule.weave.v2.parser.ParsingPhaseCategory
import org.mule.weave.v2.parser.ast.variables.NameIdentifier

case class WeaveBinaryDeserializationError(identifier: NameIdentifier, reason: String) extends Message {
  override def kind: String = MessageKind.BINARY_RESOURCE_LOADER_ERROR

  override def category: MessageCategory = ParsingPhaseCategory

  override def message: String = s"Unable to load binary file for identifier $identifier, error was: $reason"

}
