package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.SerializerContext
import org.mule.weave.v2.parser.ast.header.directives.ContentType

object ContentTypeSerializer extends AstNodeSerializer[ContentType] {

  override protected def doSerialize(node: ContentType, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val mime = serializeString(node.mime)
    val children: Seq[SerializableAstNode] = Seq(_annotations, mime)
    NodeSerializableAstNode(SerializableAstNodeKind.CONTENT_TYPE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): ContentType = {
    val mime = deserializeString(children.head)
    ContentType(mime)
  }
}
