package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.functions.DoBlockNode

object DoBlockNodeSerializer extends AstNodeSerializer[DoBlockNode] {

  override protected def doSerialize(node: DoBlockNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val header = HeaderNodeSerializer.serialize(node.header)
    val body = AstToSerializableMapper.serialize(node.body)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, header, body, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.DO_BLOCK_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): DoBlockNode = {
    val header = HeaderNodeSerializer.deserialize(children.head, context)
    val body = AstToSerializableMapper.deserialize(children(1), context)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(2), context)
    DoBlockNode(header, body, annotations)
  }
}
