package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.SerializerContext
import org.mule.weave.v2.parser.ast.header.directives.NamespaceDirective

object NamespaceDirectiveSerializer extends AstNodeSerializer[NamespaceDirective] {

  override protected def doSerialize(node: NamespaceDirective, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val prefix = NameIdentifierSerializer.serialize(node.prefix)
    val uri = UriNodeSerializer.serialize(node.uri)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, prefix, uri, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.NAMESPACE_DIRECTIVE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): NamespaceDirective = {
    val prefix = NameIdentifierSerializer.deserialize(children.head, context)
    val uri = UriNodeSerializer.deserialize(children(1), context)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(2), context)
    NamespaceDirective(prefix, uri, annotations)
  }
}
