package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.SerializerContext
import org.mule.weave.v2.parser.ast.updates.UpdateExpressionsNode

object UpdateExpressionsNodeSerializer extends AstNodeSerializer[UpdateExpressionsNode] {

  override protected def doSerialize(node: UpdateExpressionsNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val expressions = UpdateExpressionNodeSerializer.serializeSeq(node.expressions)
    val children: Seq[SerializableAstNode] = Seq(_annotations, expressions)
    NodeSerializableAstNode(SerializableAstNodeKind.UPDATE_EXPRESSIONS_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): UpdateExpressionsNode = {
    val expressions = UpdateExpressionNodeSerializer.deserializeSeq(children.head, context)
    UpdateExpressionsNode(expressions)
  }
}
