package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.SerializerContext
import org.mule.weave.v2.parser.ast.header.directives.VersionDirective

object VersionDirectiveSerializer extends AstNodeSerializer[VersionDirective] {

  override protected def doSerialize(node: VersionDirective, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val major = VersionMajorSerializer.serialize(node.major)
    val minor = VersionMinorSerializer.serialize(node.minor)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, major, minor, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.VERSION_DIRECTIVE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): VersionDirective = {
    val major = VersionMajorSerializer.deserialize(children.head, context)
    val minor = VersionMinorSerializer.deserialize(children(1), context)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(2), context)
    VersionDirective(major, minor, annotations)
  }
}
