package org.mule.weave.v2.interpreted.marker

import org.mule.weave.v2.grammar.AsOpId
import org.mule.weave.v2.interpreted.InterpreterPreCompilerMarker
import org.mule.weave.v2.parser.annotation.AstNodeAnnotation
import org.mule.weave.v2.parser.annotation.MaterializeTypeAnnotation
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.functions.FunctionNode
import org.mule.weave.v2.parser.ast.operators.BinaryOpNode
import org.mule.weave.v2.parser.ast.patterns.TypePatternNode
import org.mule.weave.v2.parser.ast.types.WeaveTypeNode
import org.mule.weave.v2.parser.phase.ParsingContext
import org.mule.weave.v2.scope.ScopesNavigator

class RequiresMaterializationMarker extends InterpreterPreCompilerMarker {

  override def mark(node: AstNode, scope: ScopesNavigator, context: ParsingContext): Unit = {
    node match {
      case bon: BinaryOpNode =>
        bon.binaryOpId match {
          case AsOpId =>
            if (!bon.rhs.isAnnotatedWith(classOf[RequiresMaterializationAnnotation])) {
              val materializedAnnotation = bon.rhs.annotation(classOf[MaterializeTypeAnnotation])

              if (materializedAnnotation.exists(_.needMaterialize)) {
                bon.rhs.annotate(RequiresMaterializationAnnotation())
              }
            }
          case _ =>
          // Nothing to do
        }

      case fn: FunctionNode =>
        fn.params.paramList.foreach(param => {
          if (!param.isAnnotatedWith(classOf[RequiresMaterializationAnnotation])) {
            if (param.wtype.isDefined) {
              val wType = param.wtype.get
              val materializedAnnotation = wType.annotation(classOf[MaterializeTypeAnnotation])

              if (materializedAnnotation.exists(_.needMaterialize)) {
                param.annotate(RequiresMaterializationAnnotation())
              }
            }
          }
        })

      case tpn: TypePatternNode =>
        tpn.pattern match {
          case wtn: WeaveTypeNode =>
            if (!tpn.pattern.isAnnotatedWith(classOf[RequiresMaterializationAnnotation])) {
              val materializedAnnotation = tpn.pattern.annotation(classOf[MaterializeTypeAnnotation])

              if (materializedAnnotation.exists(_.needMaterialize)) {
                tpn.pattern.annotate(RequiresMaterializationAnnotation())
              }
            }
          case _ =>
          // Nothing to do
        }

      case _ =>
      // Nothing to do
    }
  }
}

case class RequiresMaterializationAnnotation() extends AstNodeAnnotation {

  override def name(): String = {
    "RequiresMaterialization"
  }
}
