%dw 2.5
output application/json

type Kind = "Parameter" | "Selector" | "Literal"

@Metadata(key="parameters")
annotation Parameters(value: Array<{"name": String,"type": Type}>)
// <- {parameters: [] }

type Provider = {provider: Any, args: Array<{kind: Kind, value: String}>}

@Metadata(key="valueProvider")
annotation ValueProvider(value: Provider)

@Metadata(key="argument")
annotation Arguments(value: Array<{kind: Kind, value: String}>)

@Metadata(key="label")
annotation Label(value: String)

fun getAccountIdsValueProvider(bankId: String, region: String) = [{name: "", label: "", id: ""}]

// We define the Parameters required for this Type
// <- {parameters: [{name: "bankId", "type": String}] }
type Account = @Parameters(value = [{name: "bankId", "type": String}])
                {
                  @Label(value = "Account Region")
                  region: String,
                  accountId: @ValueProvider(value = {
                                   provider: getAccountIdsValueProvider,
                                   args: [
                                      {kind: "Parameter", value: "bankId"},
                                      {kind: "Selector", value: ".region"}
                                   ]
                                 }) String
                }

type Transaction = {
    fromBankOrgId: String,
    toBankOrgId: String,
    fromAccount: @Arguments(value = [{kind: "Selector", value: ".fromBankOrgId"}])
                 Account,
    toAccount: @Arguments(value = [{kind: "Selector", value: ".toBankOrgId"}])
                 Account
}

// Another scenario where we propagate as parameter the acting parameter from Account type even to an upper type...

type Order = {
    transaction: @Arguments(value = [
                       {kind: "Selector", value: ".fromBanckOrgId"},
                       {kind: "Selector", value: ".toBankOrgId"}]
                     )
                 Transaction,
    toBankOrgId: String, 
    fromBankOrdId: String
}


type TransactionSecondExample = @Parameters(value = [
                                 {name: "fromBankOrgId", "type": String},
                                 {name: "toBankOrgId", "type": String}
                               ])
                                {
                                    fromAccount: @Arguments(value = [{kind: "Parameter", value: "fromBankOrgId"}]) Account,
                                    toAccount: @Arguments(value = [{kind: "Parameter", value: "toBankOrgId"}]) Account
                                }

---
{
}
