package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.patterns.DeconstructObjectPatternNode

object DeconstructObjectPatternNodeSerializer extends AstNodeSerializer[DeconstructObjectPatternNode] {

  override protected def doSerialize(node: DeconstructObjectPatternNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val headKey = NameIdentifierSerializer.serialize(node.headKey)
    val headValue = NameIdentifierSerializer.serialize(node.headValue)
    val tail = NameIdentifierSerializer.serialize(node.tail)
    val onMatch = AstToSerializableMapper.serialize(node.onMatch)
    val children: Seq[SerializableAstNode] = Seq(_annotations, headKey, headValue, tail, onMatch)
    NodeSerializableAstNode(SerializableAstNodeKind.DECONSTRUCT_OBJECT_PATTERN_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): DeconstructObjectPatternNode = {
    val headKey = NameIdentifierSerializer.deserialize(children.head, context)
    val headValue = NameIdentifierSerializer.deserialize(children(1), context)
    val tail = NameIdentifierSerializer.deserialize(children(2), context)
    val onMatch = AstToSerializableMapper.deserialize(children(3), context)
    DeconstructObjectPatternNode(headKey, headValue, tail, onMatch)
  }
}
