package org.mule.weave.v2.interpreted.node

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.{ KeyValuePair, ObjectSeq }
import org.mule.weave.v2.model.values.{ KeyValue, ObjectValue }
import org.mule.weave.v2.parser.location.Location

class AstWrapperRoot(node: ExecutionNode) extends ObjectValue {

  override def evaluate(implicit ctx: EvaluationContext): T = {
    ObjectSeq(Seq(KeyValuePair(KeyValue("AST"), AstWrapper(node))).toIterator)
  }

  override def location(): Location = node.location()
}
