package org.mule.weave.v2.interpreted.node.structure.header

import org.mule.weave.v2.interpreted.node.ExecutionNode
import org.mule.weave.v2.interpreted.node.NameSlot

import scala.collection.mutable.ArrayBuffer

/**
  * The VariableTable contains a list of all the variables that will be used at any point in the whole mapping execution.
  */
class VariableTable() extends ExecutionNode {

  val variables: ArrayBuffer[NameSlot] = new ArrayBuffer[NameSlot]

  def indexOf(valueName: String) = {
    variables.indexWhere((vars) => vars.name.equals(valueName))
  }

  def size: Int = variables.size

  def createVariable(name: String): NameSlot = {
    val index: Int = indexOf(name)
    if (index == -1) {
      val nameSlot: NameSlot = NameSlot(name, variables.length)
      variables.+=(nameSlot)
      nameSlot
    } else {
      NameSlot(name, index)
    }
  }

  def variableNames(): Seq[String] = {
    variables.map(_.name)
  }

  def apply(n: Int): NameSlot = {
    variables.apply(n)
  }

  override def productElement(n: Int): Any = variables(n)

  override def productArity: Int = variables.size
}