package org.mule.weave.v2.runtime.core.functions.math

import org.mule.weave.v2.core.functions.UnaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.NumberType
import org.mule.weave.v2.model.values.NumberValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.model.values.math.Number

object SqrtNumberFunctionValue extends UnaryFunctionValue {
  override val R = NumberType

  override def doExecute(r: R.V)(implicit executionContext: EvaluationContext): Value[_] = {
    val base: Number = r.evaluate
    val expo: Number = 0.5
    NumberValue(base.pow(expo), this)
  }
}