package org.mule.weave.v2.runtime.core.functions.runtime

import org.mule.weave.v2.core.exception.ExecutionException
import org.mule.weave.v2.core.exception.InternalExecutionException
import org.mule.weave.v2.core.functions.UnaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.KeyValuePair
import org.mule.weave.v2.model.types.FunctionType
import org.mule.weave.v2.model.values.ArrayValue
import org.mule.weave.v2.model.values.BooleanValue
import org.mule.weave.v2.model.values.KeyValue
import org.mule.weave.v2.model.values.ObjectValue
import org.mule.weave.v2.model.values.StringValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.parser.exception.WeaveException
import org.mule.weave.v2.parser.location.DefaultLocationCapable

import java.io.PrintWriter
import java.io.StringWriter

object TryFunctionValue extends UnaryFunctionValue {
  override val R = FunctionType

  override def doExecute(value1: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    try {
      //We materialize so we are sure that the callback is being executed in depth.
      val callResult = value1.call()
      val result = callResult.eagerMaterialize
      ObjectValue(Array(KeyValuePair(KeyValue("success"), BooleanValue.TRUE_BOOL), KeyValuePair(KeyValue("result"), result)), DefaultLocationCapable(value1.location()))
    } catch {
      //Internal Execution Exception should never be catch it is used by control flow
      case iee: InternalExecutionException => {
        throw iee
      }
      case x: ExecutionException =>
        ObjectValue(
          Array(
            KeyValuePair(KeyValue("success"), BooleanValue.FALSE_BOOL),
            KeyValuePair(
              KeyValue("error"),
              ObjectValue(
                Array(
                  KeyValuePair(KeyValue("kind"), StringValue(x.getKind)),
                  KeyValuePair(KeyValue("message"), StringValue(x.message)),
                  KeyValuePair(KeyValue("location"), StringValue(x.location.locationString)),
                  KeyValuePair(KeyValue("stack"), ArrayValue(x.weaveStacktrace.buildStackTrace().map(_.stringValue())))),
                DefaultLocationCapable(value1.location())))),
          DefaultLocationCapable(value1.location()))
      case x: Throwable => {
        val stackTrace = {
          val writer = new StringWriter()
          x.printStackTrace(new PrintWriter(writer))
          writer.toString
        }
        ObjectValue(
          Array(
            KeyValuePair(KeyValue("success"), BooleanValue.FALSE_BOOL),
            KeyValuePair(
              KeyValue("error"),
              ObjectValue(
                Array(
                  KeyValuePair(KeyValue("kind"), StringValue(getExceptionKind(x))),
                  KeyValuePair(KeyValue("message"), StringValue(x.getClass.getCanonicalName + " " + Option(x.getMessage).getOrElse(""))),
                  KeyValuePair(KeyValue("stacktrace"), StringValue(stackTrace))),
                DefaultLocationCapable(value1.location())))),
          DefaultLocationCapable(value1.location()))
      }
    }
  }

  def getExceptionKind(e: Throwable): String = {
    e match {
      case le: WeaveException => le.getKind
      case _                  => "InternalWeaveError"
    }
  }
}

