package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.SerializerContext
import org.mule.weave.v2.parser.ast.header.directives.ImportDirective

object ImportDirectiveSerializer extends AstNodeSerializer[ImportDirective] {

  override protected def doSerialize(node: ImportDirective, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val importedModule = ImportedElementSerializer.serialize(node.importedModule)
    val subElements = ImportedElementsSerializer.serialize(node.subElements)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, importedModule, subElements, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.IMPORT_DIRECTIVE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): ImportDirective = {
    val importedModule = ImportedElementSerializer.deserialize(children.head, context)
    val subElements = ImportedElementsSerializer.deserialize(children(1), context)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(2), context)
    ImportDirective(importedModule, subElements, annotations)
  }
}
