%dw 2.0

import * from dw::Runtime
import * from dw::Client

var response = {
  status: 200,
  body: failBinary()
}

type Literal = "Literal"
type LiteralBool = true

type TestBin = {
  status: Number,
  body: Binary
}

type TestStrNull = {
  status: Number,
  body: String | Null
}

type TestLiteral = {
  status: Number,
  body: Literal
}

fun test(response: TestStrNull) = response.status + 1
fun test(response: TestLiteral) = response.status + 2
fun test(response: TestBin) = response.status

fun test2(arg: String) = "string"
fun test2(arg: Number) = "number"
fun test2(arg: LiteralBool) = "true"
---
{
  status_as: (response as TestBin).status,
  status_fun: test(response),
  test2: try(() -> test2(failBinary())).success match {
    case false -> "coercion evaluates the binary value"
    case true -> "failure"
  }
}
