package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.header.directives.AnnotationParameterNode
import org.mule.weave.v2.parser.ast.types.WeaveTypeNode

object AnnotationParameterNodeSerializer extends AstNodeSerializer[AnnotationParameterNode] {

  override protected def doSerialize(node: AnnotationParameterNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val nameIdentifier = NameIdentifierSerializer.serialize(node.nameIdentifier)
    val weaveType = AstToSerializableMapper.serialize(node.weaveType)
    val defaultValue = AstToSerializableMapper.serializeMaybe(node.defaultValue)
    val children: Seq[SerializableAstNode] = Seq(_annotations, nameIdentifier, weaveType, defaultValue)
    NodeSerializableAstNode(SerializableAstNodeKind.ANNOTATION_PARAMETER_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): AnnotationParameterNode = {
    val identifier = NameIdentifierSerializer.deserialize(children.head, context)
    val wtype = AstToSerializableMapper.deserialize(children(1), context).asInstanceOf[WeaveTypeNode]
    val defaultValue = AstToSerializableMapper.deserializeMaybe(children(2), context)
    AnnotationParameterNode(identifier, wtype, defaultValue)
  }
}
