package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.SerializerContext
import org.mule.weave.v2.parser.ast.functions.UsingVariableAssignments

object UsingVariableAssignmentsSerializer extends AstNodeSerializer[UsingVariableAssignments] {

  override protected def doSerialize(node: UsingVariableAssignments, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val assignmentSeq = UsingVariableAssignmentSerializer.serializeSeq(node.assignmentSeq)
    val children: Seq[SerializableAstNode] = Seq(_annotations, assignmentSeq)
    NodeSerializableAstNode(SerializableAstNodeKind.USING_VARIABLE_ASSIGNMENTS_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): UsingVariableAssignments = {
    val assignmentSeq = UsingVariableAssignmentSerializer.deserializeSeq(children.head, context)
    UsingVariableAssignments(assignmentSeq)
  }
}
