%dw 2.0
type DependencyTree = { id: String, children: Array<DependencyTree> }
var lines = in0[7 to -1] splitBy "\n[INFO] "

fun updateGraph(line: String, parent: DependencyTree) = do {
  var head = line[0 to 2]
  var tail = line[3 to -1]
  ---
  head match {
    case "+- " ->
        parent update {
            case .children -> $ << {
                id: tail,
                children: []
            }
        }
    else ->
        parent update {
            case .children[-1] -> updateGraph(tail, $)
        }
  }
}

fun processLines(lines: Array<String>, parent: DependencyTree) = do {
  lines reduce ((line, accumulator = parent) -> do {
      updateGraph(line, accumulator)
    })
}
output application/json
---
processLines(lines[1 to -1], {id: lines[0], children: []} )