package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.SerializerContext
import org.mule.weave.v2.parser.ast.header.directives.ImportedElement

object ImportedElementSerializer extends AstNodeSerializer[ImportedElement] {

  override protected def doSerialize(node: ImportedElement, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val elementName = NameIdentifierSerializer.serialize(node.elementName)
    val alias = NameIdentifierSerializer.serializeMaybe(node.alias)
    val children: Seq[SerializableAstNode] = Seq(_annotations, elementName, alias)
    NodeSerializableAstNode(SerializableAstNodeKind.IMPORTED_ELEMENT_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): ImportedElement = {
    val name = NameIdentifierSerializer.deserialize(children.head, context)
    val alias = NameIdentifierSerializer.deserializeMaybe(children(1), context)
    ImportedElement(name, alias)
  }
}
