package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.logical.OrNode

object OrNodeSerializer extends AstNodeSerializer[OrNode] {

  override protected def doSerialize(node: OrNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val lhs = AstToSerializableMapper.serialize(node.lhs)
    val rhs = AstToSerializableMapper.serialize(node.rhs)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, lhs, rhs, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.OR_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): OrNode = {
    val lhs = AstToSerializableMapper.deserialize(children.head, context)
    val rhs = AstToSerializableMapper.deserialize(children(1), context)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(2), context)
    OrNode(lhs, rhs, annotations)
  }
}
