package org.mule.weave.v2.interpreted.debugger.server

trait ClientConnectionListener {

  /**
    * Notified when a client gets connected
    */
  def onClientConnected(): Unit

  /**
    * Notified when a client gets disconnected
    */
  def onClientDisconnected(): Unit

  /**
    * Notified when an error occurred on connetion
    * @param e The exception
    */
  def onConnectionError(e: Exception): Unit = {}

}
