%dw 2.0
output application/json
fun filter<T>(items: Array<T>, callback: (item: T , index:Number) -> Boolean ): Array<T> =
    doFilter(0, items, callback)

fun doFilter<T>(index: Number,items: Array<T>, callback: (item: T , index:Number) -> Boolean ): Array<T> =
    items match {
        case [x ~ xs] ->
            if(callback(x, index))
                [x ~ doFilter(index + 1, xs, callback)]
            else
                doFilter(index + 1, xs, callback)
        case [] -> []
    }

---
{
 root:
    {
      a: in0.list filter $.name == "Mariano"
    }
}