/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.interpreted.module;

import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.mule.weave.v2.interpreted.module.WeaveDataFormat;
import org.mule.weave.v2.interpreted.module.WeaveWriter$;
import org.mule.weave.v2.interpreted.module.WeaveWriterSettings;
import org.mule.weave.v2.io.SeekableStream;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.ArraySeq;
import org.mule.weave.v2.model.structure.KeyValuePair;
import org.mule.weave.v2.model.structure.NameSeq;
import org.mule.weave.v2.model.structure.NameValuePair;
import org.mule.weave.v2.model.structure.Namespace;
import org.mule.weave.v2.model.structure.ObjectSeq;
import org.mule.weave.v2.model.structure.QualifiedName;
import org.mule.weave.v2.model.structure.schema.Schema;
import org.mule.weave.v2.model.structure.schema.Schema$;
import org.mule.weave.v2.model.structure.schema.SchemaProperty;
import org.mule.weave.v2.model.structure.schema.SchemaProperty$;
import org.mule.weave.v2.model.types.ArrayType$;
import org.mule.weave.v2.model.types.BinaryType$;
import org.mule.weave.v2.model.types.BooleanType$;
import org.mule.weave.v2.model.types.DateTimeType$;
import org.mule.weave.v2.model.types.FunctionType$;
import org.mule.weave.v2.model.types.LocalDateTimeType$;
import org.mule.weave.v2.model.types.LocalDateType$;
import org.mule.weave.v2.model.types.LocalTimeType$;
import org.mule.weave.v2.model.types.NamespaceType$;
import org.mule.weave.v2.model.types.NullType$;
import org.mule.weave.v2.model.types.NumberType$;
import org.mule.weave.v2.model.types.ObjectType$;
import org.mule.weave.v2.model.types.PeriodType$;
import org.mule.weave.v2.model.types.RangeType$;
import org.mule.weave.v2.model.types.RegexType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.types.TimeType$;
import org.mule.weave.v2.model.types.TimeZoneType$;
import org.mule.weave.v2.model.types.Type;
import org.mule.weave.v2.model.values.FunctionParameter;
import org.mule.weave.v2.model.values.FunctionValue;
import org.mule.weave.v2.model.values.StringValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.model.values.helper.AttributeHelper$;
import org.mule.weave.v2.model.values.math.Number;
import org.mule.weave.v2.module.ConfigurableReaderWriter;
import org.mule.weave.v2.module.DataFormat;
import org.mule.weave.v2.module.writer.BufferedIOWriter;
import org.mule.weave.v2.module.writer.BufferedIOWriter$;
import org.mule.weave.v2.module.writer.TargetProvider;
import org.mule.weave.v2.module.writer.Writer;
import org.mule.weave.v2.parser.location.Location;
import org.mule.weave.v2.parser.location.LocationCapable;
import org.mule.weave.v2.util.BinaryHelper$;
import org.mule.weave.v2.utils.StringEscapeHelper$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IndexedSeqOptimized;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Stack;
import scala.collection.mutable.Stack$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\tEg\u0001B\u00193\u0001}B\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\t-\u0002\u0011)\u0019!C\u0001/\"AA\f\u0001B\u0001B\u0003%\u0001\f\u0003\u0005^\u0001\t\u0005\t\u0015a\u0003_\u0011\u0015!\u0007\u0001\"\u0001f\u0011!I\u0005\u0001#b\u0001\n\u0013Y\u0007bB8\u0001\u0005\u0004%I\u0001\u001d\u0005\b\u0003\u000b\u0001\u0001\u0015!\u0003r\u0011%\t9\u0001\u0001a\u0001\n\u0013\tI\u0001C\u0005\u0002\u0012\u0001\u0001\r\u0011\"\u0003\u0002\u0014!A\u0011q\u0004\u0001!B\u0013\tY\u0001C\u0005\u0002\"\u0001\u0001\r\u0011\"\u0003\u0002$!I\u00111\u0006\u0001A\u0002\u0013%\u0011Q\u0006\u0005\t\u0003c\u0001\u0001\u0015)\u0003\u0002&!9\u00111\u0007\u0001\u0005B\u0005%\u0001bBA\u001b\u0001\u0011\u0005\u0013q\u0007\u0005\b\u0003s\u0001A\u0011AA\u001c\u0011\u001d\tY\u0004\u0001C\u0001\u0003oAq!!\u0010\u0001\t\u0003\ny\u0004C\u0004\u0002T\u0001!\t!a\u000e\t\u000f\u0005U\u0003\u0001\"\u0011\u0002X!9\u0011\u0011\u0010\u0001\u0005\u0002\u0005m\u0004bBAA\u0001\u0011%\u00111\u0011\u0005\b\u0003\u0013\u0003A\u0011BAF\u0011\u001d\ty\t\u0001C\u0005\u0003#Cq!!&\u0001\t\u0013\t9\nC\u0004\u0002\u001e\u0002!I!a\u000e\t\u000f\u0005}\u0005\u0001\"\u0003\u0002\"\"9\u0011\u0011\u0016\u0001\u0005\n\u0005-\u0006bBAX\u0001\u0011\u0005\u0011\u0011\u0017\u0005\b\u0003o\u0003A\u0011BA\u001c\u0011\u001d\tI\f\u0001C!\u0003wCq!!0\u0001\t\u0003\ty\fC\u0004\u0002j\u0002!\t!a;\t\u000f\tM\u0001\u0001\"\u0001\u0003\u0016!9!1\u0004\u0001\u0005\u0002\u0005]\u0002b\u0002B\u000f\u0001\u0011E#q\u0004\u0005\b\u0005\u0007\u0002A\u0011\u0002B#\u0011\u001d\u0011Y\u0005\u0001C\u0005\u0005\u001bBqAa\u0018\u0001\t\u0013\u0011\t\u0007C\u0004\u0003\u0006\u0002!IAa\"\t\u000f\t5\u0005\u0001\"\u0011\u00028!9!q\u0012\u0001\u0005B\tEua\u0002BVe!\u0005!Q\u0016\u0004\u0007cIB\tAa,\t\r\u0011lC\u0011\u0001BY\u0011\u001d\u0011\u0019,\fC\u0001\u0005kCqAa-.\t\u0003\u00119MA\u0006XK\u00064Xm\u0016:ji\u0016\u0014(BA\u001a5\u0003\u0019iw\u000eZ;mK*\u0011QGN\u0001\fS:$XM\u001d9sKR,GM\u0003\u00028q\u0005\u0011aO\r\u0006\u0003si\nQa^3bm\u0016T!a\u000f\u001f\u0002\t5,H.\u001a\u0006\u0002{\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0011$\u0011\u0005\u0005#U\"\u0001\"\u000b\u0003\r\u000bQa]2bY\u0006L!!\u0012\"\u0003\r\u0005s\u0017PU3g!\t95*D\u0001I\u0015\tI%*\u0001\u0004xe&$XM\u001d\u0006\u0003gYJ!\u0001\u0014%\u0003\r]\u0013\u0018\u000e^3s\u0003\ty7\u000f\u0005\u0002P)6\t\u0001K\u0003\u0002R%\u0006\u0011\u0011n\u001c\u0006\u0002'\u0006!!.\u0019<b\u0013\t)\u0006K\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW.\u0001\u0005tKR$\u0018N\\4t+\u0005A\u0006CA-[\u001b\u0005\u0011\u0014BA.3\u0005M9V-\u0019<f/JLG/\u001a:TKR$\u0018N\\4t\u0003%\u0019X\r\u001e;j]\u001e\u001c\b%A\u0002dib\u0004\"a\u00182\u000e\u0003\u0001T!!\u0019\u001c\u0002\u000b5|G-\u001a7\n\u0005\r\u0004'!E#wC2,\u0018\r^5p]\u000e{g\u000e^3yi\u00061A(\u001b8jiz\"2AZ5k)\t9\u0007\u000e\u0005\u0002Z\u0001!)Q,\u0002a\u0002=\")Q*\u0002a\u0001\u001d\")a+\u0002a\u00011V\tA\u000e\u0005\u0002H[&\u0011a\u000e\u0013\u0002\u0011\u0005V4g-\u001a:fI&{uK]5uKJ\f!\u0002Z3dY\u0006\u0014X\r\u001a(t+\u0005\t\bc\u0001:xs6\t1O\u0003\u0002uk\u00069Q.\u001e;bE2,'B\u0001<C\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003qN\u0014Qa\u0015;bG.\u00042A\u001d>}\u0013\tY8OA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bcA?\u0002\u00025\taP\u0003\u0002\u0000A\u0006I1\u000f\u001e:vGR,(/Z\u0005\u0004\u0003\u0007q(!\u0003(b[\u0016\u001c\b/Y2f\u0003-!Wm\u00197be\u0016$gj\u001d\u0011\u0002\u0019%t7/\u001b3f\u0011\u0016\fG-\u001a:\u0016\u0005\u0005-\u0001cA!\u0002\u000e%\u0019\u0011q\u0002\"\u0003\u000f\t{w\u000e\\3b]\u0006\u0001\u0012N\\:jI\u0016DU-\u00193fe~#S-\u001d\u000b\u0005\u0003+\tY\u0002E\u0002B\u0003/I1!!\u0007C\u0005\u0011)f.\u001b;\t\u0013\u0005u!\"!AA\u0002\u0005-\u0011a\u0001=%c\u0005i\u0011N\\:jI\u0016DU-\u00193fe\u0002\na!\u001b8eK:$XCAA\u0013!\r\t\u0015qE\u0005\u0004\u0003S\u0011%aA%oi\u0006Q\u0011N\u001c3f]R|F%Z9\u0015\t\u0005U\u0011q\u0006\u0005\n\u0003;i\u0011\u0011!a\u0001\u0003K\tq!\u001b8eK:$\b%A\ttkB\u0004xN\u001d;t'R\u0014X-Y7j]\u001e\fQa\u00197pg\u0016$\"!!\u0006\u0002\u0011\u0011|\u0017J\u001c3f]R\f\u0001\u0002Z8EK\u0012,g\u000e^\u0001\u000egR\f'\u000f\u001e#pGVlWM\u001c;\u0015\t\u0005U\u0011\u0011\t\u0005\b\u0003\u0007\u001a\u0002\u0019AA#\u0003!awnY1uS>t\u0007\u0003BA$\u0003\u001fj!!!\u0013\u000b\t\u0005\r\u00131\n\u0006\u0004\u0003\u001b2\u0014A\u00029beN,'/\u0003\u0003\u0002R\u0005%#a\u0004'pG\u0006$\u0018n\u001c8DCB\f'\r\\3\u0002+M$\u0018M\u001d;IK\u0006$WM]%g%\u0016\fX/\u001b:fI\u0006yA-\u001a4j]\u0016t\u0015-\\3ta\u0006\u001cW\r\u0006\u0005\u0002\u0016\u0005e\u00131LA;\u0011\u001d\t\u0019%\u0006a\u0001\u0003\u000bBq!!\u0018\u0016\u0001\u0004\ty&\u0001\u0004qe\u00164\u0017\u000e\u001f\t\u0005\u0003C\nyG\u0004\u0003\u0002d\u0005-\u0004cAA3\u00056\u0011\u0011q\r\u0006\u0004\u0003Sr\u0014A\u0002\u001fs_>$h(C\u0002\u0002n\t\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA9\u0003g\u0012aa\u0015;sS:<'bAA7\u0005\"9\u0011qO\u000bA\u0002\u0005}\u0013aA;sS\u0006aq-\u001a;Qe\u00164\u0017\u000e\u001f$peR1\u0011qLA?\u0003\u007fBq!!\u0018\u0017\u0001\u0004\ty\u0006C\u0004\u0002xY\u0001\r!a\u0018\u0002\u001d]\u0014\u0018\u000e^3OC6,7\u000f]1dKR1\u0011QCAC\u0003\u000fCq!!\u0018\u0018\u0001\u0004\ty\u0006C\u0004\u0002x]\u0001\r!a\u0018\u0002\u001fM$\u0018M\u001d;BiR\u0014\u0018NY;uKN$B!!\u0006\u0002\u000e\"9\u00111\t\rA\u0002\u0005\u0015\u0013!D3oI\u0006#HO]5ckR,7\u000f\u0006\u0003\u0002\u0016\u0005M\u0005bBA\"3\u0001\u0007\u0011QI\u0001\fgR\f'\u000f^(cU\u0016\u001cG\u000f\u0006\u0002\u0002\u001aR!\u0011QCAN\u0011\u0015i&\u0004q\u0001_\u0003%)g\u000eZ(cU\u0016\u001cG/\u0001\u0006ti\u0006\u0014H/\u0011:sCf$B!a)\u0002(R!\u0011QCAS\u0011\u0015iF\u0004q\u0001_\u0011\u001d\t\u0019\u0005\ba\u0001\u0003\u000b\n\u0001\"\u001a8e\u0003J\u0014\u0018-\u001f\u000b\u0005\u0003+\ti\u000bC\u0004\u0002Du\u0001\r!!\u0012\u0002\u001dI,\u0017/^5sKN\fVo\u001c;fgR!\u00111BAZ\u0011\u001d\t)L\ba\u0001\u0003?\n1a[3z\u0003\u001dqWm\u001e7j]\u0016\faA]3tk2$X#\u0001(\u0002\u0017]\u0014\u0018\u000e^3TG\",W.\u0019\u000b\u0007\u0003\u0003\f)-!6\u0015\t\u0005U\u00111\u0019\u0005\u0006;\u0006\u0002\u001dA\u0018\u0005\b\u0003\u000f\f\u0003\u0019AAe\u0003\u0005!\b\u0003BAf\u0003#l!!!4\u000b\u0007\u0005=\u0007-A\u0003usB,7/\u0003\u0003\u0002T\u00065'\u0001\u0002+za\u0016Dq!a6\"\u0001\u0004\tI.\u0001\u0004tG\",W.\u0019\t\u0006\u0003\u0006m\u0017q\\\u0005\u0004\u0003;\u0014%AB(qi&|g\u000e\u0005\u0003\u0002b\u0006\u0015XBAAr\u0015\r\t9N`\u0005\u0005\u0003O\f\u0019O\u0001\u0004TG\",W.Y\u0001\u000ecV\fG.\u001b4jK\u0012t\u0015-\\3\u0015\r\u00055\u0018\u0011\u001fB\u0003)\u0011\t)\"a<\t\u000bu\u0013\u00039\u00010\t\u000f\u0005U&\u00051\u0001\u0002tB1\u0011Q_A~\u0003\u007fl!!a>\u000b\u0007\u0005e\b-\u0001\u0004wC2,Xm]\u0005\u0005\u0003{\f9PA\u0003WC2,X\rE\u0002~\u0005\u0003I1Aa\u0001\u007f\u00055\tV/\u00197jM&,GMT1nK\"9!q\u0001\u0012A\u0002\t%\u0011AC1uiJL'-\u001e;fgB)\u0011)a7\u0003\fA1\u0011Q_A~\u0005\u001b\u00012! B\b\u0013\r\u0011\tB \u0002\b\u001d\u0006lWmU3r\u00039\tGN]3bIf$UMZ5oK\u0012$B!a\u0003\u0003\u0018!1!\u0011D\u0012A\u0002q\f!A\\:\u0002A]\u0014\u0018\u000e^3E_\u000e,X.\u001a8u'\u0016\u0004\u0018M]1u_JLeMU3rk&\u0014X\rZ\u0001\rI><&/\u001b;f-\u0006dW/\u001a\u000b\u0005\u0005C\u0011)\u0003\u0006\u0003\u0002\u0016\t\r\u0002\"B/&\u0001\bq\u0006b\u0002B\u0014K\u0001\u0007!\u0011F\u0001\u0002mB\"!1\u0006B\u0019!\u0019\t)0a?\u0003.A!!q\u0006B\u0019\u0019\u0001!ABa\r\u0003&\u0005\u0005\t\u0011!B\u0001\u0005k\u00111a\u0018\u00132#\u0011\u00119D!\u0010\u0011\u0007\u0005\u0013I$C\u0002\u0003<\t\u0013qAT8uQ&tw\rE\u0002B\u0005\u007fI1A!\u0011C\u0005\r\te._\u0001\u0010O\u0016$XK\\5rk\u0016\u0004&/\u001a4jqR!\u0011q\fB$\u0011\u0019\u0011IE\na\u0001y\u0006Ia.Y7fgB\f7-Z\u0001\fSN$\u0015\r^3WC2,X\r\u0006\u0003\u0003P\tMC\u0003BA\u0006\u0005#BQ!X\u0014A\u0004yCqAa\n(\u0001\u0004\u0011)\u0006\r\u0003\u0003X\tm\u0003CBA{\u0003w\u0014I\u0006\u0005\u0003\u00030\tmC\u0001\u0004B/\u0005'\n\t\u0011!A\u0003\u0002\tU\"aA0%g\u0005\u00192m\u001c7mK\u000e$XK\u001c3fG2\f'/\u001a3O'R!!1\rB=)\u0011\u0011)Ga\u001e\u0011\u000b\t\u001d$\u0011\u000f?\u000f\t\t%$Q\u000e\b\u0005\u0003K\u0012Y'C\u0001D\u0013\r\u0011yGQ\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011\u0019H!\u001e\u0003\u0007M+\u0017OC\u0002\u0003p\tCQ!\u0018\u0015A\u0004yCqAa\u001f)\u0001\u0004\u0011i(\u0001\u0006wC2,X\rU1jeN\u0004bAa\u001a\u0003r\t}\u0004cA?\u0003\u0002&\u0019!1\u0011@\u0003\u0019-+\u0017PV1mk\u0016\u0004\u0016-\u001b:\u0002!]\u0014\u0018\u000e^3Rk>$Xm\u0015;sS:<G\u0003BA\u000b\u0005\u0013CqAa#*\u0001\u0004\ty&\u0001\u0005tiJ4\u0016\r\\;f\u0003\u00151G.^:i\u0003)!\u0017\r^1G_Jl\u0017\r^\u000b\u0003\u0005'\u0003R!QAn\u0005+\u0003dAa&\u0003\"\n\u001d\u0006\u0003\u0003BM\u00057\u0013yJ!*\u000e\u0003)K1A!(K\u0005)!\u0015\r^1G_Jl\u0017\r\u001e\t\u0005\u0005_\u0011\t\u000bB\u0006\u0003$.\n\t\u0011!A\u0003\u0002\tU\"aA0%iA!!q\u0006BT\t-\u0011IkKA\u0001\u0002\u0003\u0015\tA!\u000e\u0003\u0007}#S'A\u0006XK\u00064Xm\u0016:ji\u0016\u0014\bCA-.'\ti\u0003\t\u0006\u0002\u0003.\u0006)\u0011\r\u001d9msR1!q\u0017B^\u0005\u000b$2a\u001aB]\u0011\u0015iv\u0006q\u0001_\u0011\u001d\u0011il\fa\u0001\u0005\u007f\u000b!\u0001\u001e9\u0011\u0007\u001d\u0013\t-C\u0002\u0003D\"\u0013a\u0002V1sO\u0016$\bK]8wS\u0012,'\u000fC\u0003W_\u0001\u0007\u0001\f\u0006\u0004\u0003J\n5'q\u001a\u000b\u0004O\n-\u0007\"B/1\u0001\bq\u0006\"B'1\u0001\u0004q\u0005\"\u0002,1\u0001\u0004A\u0006")
public class WeaveWriter
implements Writer {
    private BufferedIOWriter writer;
    private final OutputStream os;
    private final WeaveWriterSettings settings;
    private final Stack<ArrayBuffer<Namespace>> declaredNs;
    private boolean insideHeader;
    private int indent;
    private volatile boolean bitmap$0;

    public static WeaveWriter apply(OutputStream outputStream, WeaveWriterSettings weaveWriterSettings, EvaluationContext evaluationContext) {
        return WeaveWriter$.MODULE$.apply(outputStream, weaveWriterSettings, evaluationContext);
    }

    public static WeaveWriter apply(TargetProvider targetProvider, WeaveWriterSettings weaveWriterSettings, EvaluationContext evaluationContext) {
        return WeaveWriter$.MODULE$.apply(targetProvider, weaveWriterSettings, evaluationContext);
    }

    public final void writeValue(Value<?> value, EvaluationContext ctx) {
        Writer.writeValue$((Writer)this, value, (EvaluationContext)ctx);
    }

    public String getName() {
        return Writer.getName$((Writer)this);
    }

    public final void endDocument(LocationCapable location) {
        Writer.endDocument$((Writer)this, (LocationCapable)location);
    }

    public void doEndDocument(LocationCapable location) {
        Writer.doEndDocument$((Writer)this, (LocationCapable)location);
    }

    public void setOption(Location location, String optionName, Object value, EvaluationContext ctx) {
        ConfigurableReaderWriter.setOption$((ConfigurableReaderWriter)this, (Location)location, (String)optionName, (Object)value, (EvaluationContext)ctx);
    }

    public WeaveWriterSettings settings() {
        return this.settings;
    }

    private BufferedIOWriter writer$lzycompute() {
        WeaveWriter weaveWriter = this;
        synchronized (weaveWriter) {
            if (!this.bitmap$0) {
                this.writer = BufferedIOWriter$.MODULE$.apply(this.os, StandardCharsets.UTF_8, this.settings().bufferSize());
                this.bitmap$0 = true;
            }
        }
        return this.writer;
    }

    private BufferedIOWriter writer() {
        return !this.bitmap$0 ? this.writer$lzycompute() : this.writer;
    }

    private Stack<ArrayBuffer<Namespace>> declaredNs() {
        return this.declaredNs;
    }

    private boolean insideHeader() {
        return this.insideHeader;
    }

    private void insideHeader_$eq(boolean x$1) {
        this.insideHeader = x$1;
    }

    private int indent() {
        return this.indent;
    }

    private void indent_$eq(int x$1) {
        this.indent = x$1;
    }

    public boolean supportsStreaming() {
        return false;
    }

    public void close() {
        this.writer().close();
    }

    public void doIndent() {
        this.indent_$eq(this.indent() + 1);
    }

    public void doDedent() {
        this.indent_$eq(this.indent() - 1);
    }

    public void startDocument(LocationCapable location) {
        this.declaredNs().push((Object)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$));
    }

    public void startHeaderIfRequired() {
        block0: {
            if (this.insideHeader()) break block0;
            this.writer().write("%dw 2.0");
            this.newline();
            this.insideHeader_$eq(true);
        }
    }

    public void defineNamespace(LocationCapable location, String prefix, String uri) {
        this.startHeaderIfRequired();
        this.writeNamespace(prefix, uri);
    }

    public String getPrefixFor(String prefix, String uri) {
        String string;
        Option mayBeNamespace = ((TraversableLike)this.declaredNs().toStream().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> (ArrayBuffer)x$1.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)WeaveWriter.$anonfun$getPrefixFor$2(uri, x$2))), Stream$.MODULE$.canBuildFrom())).headOption();
        Option option = mayBeNamespace;
        if (option instanceof Some) {
            Some some = (Some)option;
            Namespace value = (Namespace)some.value();
            string = value.prefix();
        } else if (None$.MODULE$.equals(option)) {
            String resultPrefix = prefix;
            if (prefix.isEmpty()) {
                resultPrefix = new StringBuilder(2).append("ns").append(((SeqLike)this.declaredNs().top()).size()).toString();
            }
            boolean alreadyDefined = true;
            int i = 0;
            ObjectRef tmpPrefix = ObjectRef.create((Object)resultPrefix);
            while (alreadyDefined) {
                if (((IndexedSeqOptimized)this.declaredNs().top()).exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)WeaveWriter.$anonfun$getPrefixFor$3(tmpPrefix, x$3)))) {
                    tmpPrefix.elem = new StringBuilder(0).append(resultPrefix).append(i).toString();
                } else {
                    alreadyDefined = false;
                    resultPrefix = (String)tmpPrefix.elem;
                }
                ++i;
            }
            string = resultPrefix;
        } else {
            throw new MatchError((Object)option);
        }
        return string;
    }

    private void writeNamespace(String prefix, String uri) {
        block0: {
            if (!new StringOps(Predef$.MODULE$.augmentString(uri)).nonEmpty() || ((IndexedSeqOptimized)this.declaredNs().top()).exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)WeaveWriter.$anonfun$writeNamespace$1(prefix, x$4)))) break block0;
            this.writer().write("ns ");
            this.writer().write(prefix);
            this.writer().write(" ");
            this.writer().write(uri);
            ((ArrayBuffer)this.declaredNs().top()).$plus$eq((Object)new Namespace(prefix, uri));
            this.newline();
        }
    }

    private void startAttributes(LocationCapable location) {
        this.writer().write(" @(");
    }

    private void endAttributes(LocationCapable location) {
        this.writer().write(")");
    }

    private void startObject(EvaluationContext ctx) {
        this.writer().write("{");
        this.doIndent();
        this.newline();
    }

    private void endObject() {
        this.doDedent();
        this.newline();
        this.writer().write("}");
    }

    private void startArray(LocationCapable location, EvaluationContext ctx) {
        this.writer().write("[");
        this.doIndent();
        this.newline();
    }

    private void endArray(LocationCapable location) {
        this.doDedent();
        this.newline();
        this.writer().write("]");
    }

    public boolean requiresQuotes(String key) {
        return StringEscapeHelper$.MODULE$.keyRequiresQuotes(key);
    }

    private void newline() {
        block1: {
            if (this.settings().indent().length() <= 0) break block1;
            this.writer().write("\n");
            if (this.indent() > 0) {
                this.writer().write(new StringOps(Predef$.MODULE$.augmentString(this.settings().indent())).$times(this.indent()));
            }
        }
    }

    public OutputStream result() {
        this.writer().flush();
        return this.os;
    }

    public void writeSchema(Type t, Option<Schema> schema, EvaluationContext ctx) {
        Some some;
        Schema theSchema;
        Option<Schema> option = schema;
        if (option instanceof Some && (theSchema = (Schema)(some = (Some)option).value()).properties(ctx).nonEmpty()) {
            this.writer().write(" as ");
            this.writer().write(t.baseType(ctx).name());
            this.writer().write(" {");
            BooleanRef first = BooleanRef.create((boolean)true);
            theSchema.properties(ctx).foreach((Function1 & Serializable & scala.Serializable)sproperty -> {
                WeaveWriter.$anonfun$writeSchema$1(this, first, ctx, sproperty);
                return BoxedUnit.UNIT;
            });
            this.writer().write("}");
            this.writer().flush();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void qualifiedName(Value<QualifiedName> key, Option<Value<NameSeq>> attributes, EvaluationContext ctx) {
        Some some;
        Namespace ns;
        QualifiedName evaluate = (QualifiedName)key.evaluate(ctx);
        Option option = evaluate.namespace();
        if (option instanceof Some && new StringOps(Predef$.MODULE$.augmentString((ns = (Namespace)(some = (Some)option).value()).uri())).nonEmpty()) {
            this.writer().write(new StringBuilder(1).append(this.getUniquePrefix(ns)).append("#").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        if (this.requiresQuotes(evaluate.name())) {
            this.writeQuoteString(evaluate.name());
        } else {
            this.writer().write(evaluate.name());
        }
        Option<Value<NameSeq>> option2 = attributes;
        if (option2 instanceof Some) {
            BoxedUnit boxedUnit;
            Some some2 = (Some)option2;
            Value attrs = (Value)some2.value();
            NameSeq attributes2 = (NameSeq)attrs.evaluate(ctx);
            if (!attributes2.isEmpty()) {
                this.startAttributes((LocationCapable)attrs);
                BooleanRef first = BooleanRef.create((boolean)true);
                attributes2.toIterator().foreach((Function1 & Serializable & scala.Serializable)nvp -> {
                    WeaveWriter.$anonfun$qualifiedName$1(this, first, ctx, nvp);
                    return BoxedUnit.UNIT;
                });
                this.endAttributes((LocationCapable)attrs);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (None$.MODULE$.equals(option2)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option2);
        }
    }

    public boolean alreadyDefined(Namespace ns) {
        return this.declaredNs().exists((Function1 & Serializable & scala.Serializable)context -> BoxesRunTime.boxToBoolean((boolean)context.exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)WeaveWriter.$anonfun$alreadyDefined$2(ns$1, x$5)))));
    }

    public void writeDocumentSeparatorIfRequired() {
        block0: {
            if (!this.insideHeader()) break block0;
            this.writer().write("---");
            this.newline();
            this.insideHeader_$eq(false);
        }
    }

    public void doWriteValue(Value<?> v, EvaluationContext ctx) {
        block31: {
            boolean ignoreSchema = this.settings().ignoreSchema();
            this.writeDocumentSeparatorIfRequired();
            Value<?> value = v;
            if (BooleanType$.MODULE$.accepts(value, ctx)) {
                this.writer().write(v.evaluate(ctx).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (NumberType$.MODULE$.accepts(value, ctx)) {
                this.writer().write(((Number)NumberType$.MODULE$.coerce(v, ctx).evaluate(ctx)).toCanonicalString(ctx));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (NullType$.MODULE$.accepts(value, ctx)) {
                this.writer().write("null");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (RangeType$.MODULE$.accepts(value, ctx)) {
                this.writeValue(ArrayType$.MODULE$.coerce(v, ctx), ctx);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (ArrayType$.MODULE$.accepts(value, ctx)) {
                BoxedUnit boxedUnit;
                Iterator iterator = ((ArraySeq)v.evaluate(ctx)).toIterator();
                if (iterator.isEmpty()) {
                    this.writer().write("[]");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.startArray((LocationCapable)v, ctx);
                    BooleanRef first = BooleanRef.create((boolean)true);
                    Iterator elements = this.settings().limitCollectionSize() ? iterator.take(this.settings().maxCollectionSize()) : iterator;
                    elements.foreach((Function1 & Serializable & scala.Serializable)v2 -> {
                        WeaveWriter.$anonfun$doWriteValue$1(this, first, ctx, v2);
                        return BoxedUnit.UNIT;
                    });
                    this.endArray((LocationCapable)v);
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else if (ObjectType$.MODULE$.accepts(value, ctx)) {
                BoxedUnit boxedUnit;
                Seq valuePairs = ((ObjectSeq)v.evaluate(ctx)).toSeq(ctx);
                if (valuePairs.isEmpty()) {
                    this.writer().write("{}");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    Object object;
                    Seq<Namespace> missingNamespace = this.collectUndeclaredNS((Seq<KeyValuePair>)valuePairs, ctx);
                    boolean needNSDeclarations = missingNamespace.nonEmpty();
                    if (needNSDeclarations) {
                        this.declaredNs().push((Object)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$));
                        this.writer().write("do ");
                        this.startObject(ctx);
                        missingNamespace.foreach((Function1 & Serializable & scala.Serializable)namespace -> {
                            this.writeNamespace(this.getUniquePrefix(namespace), namespace.uri());
                            return BoxedUnit.UNIT;
                        });
                        this.writer().write("---");
                        this.newline();
                    }
                    this.startObject(ctx);
                    BooleanRef first = BooleanRef.create((boolean)true);
                    Seq elements = this.settings().limitCollectionSize() ? (Seq)valuePairs.take(this.settings().maxCollectionSize()) : valuePairs;
                    elements.foreach((Function1 & Serializable & scala.Serializable)ekv -> {
                        WeaveWriter.$anonfun$doWriteValue$3(this, first, ctx, ekv);
                        return BoxedUnit.UNIT;
                    });
                    if (needNSDeclarations) {
                        this.endObject();
                        object = this.declaredNs().pop();
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    this.endObject();
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit3 = boxedUnit;
            } else if (FunctionType$.MODULE$.accepts(value, ctx)) {
                FunctionParameter[] parameters = ((FunctionValue)FunctionType$.MODULE$.coerce(v, ctx)).parameters();
                this.writer().write("(");
                BooleanRef first = BooleanRef.create((boolean)true);
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parameters)).foreach((Function1 & Serializable & scala.Serializable)param -> {
                    WeaveWriter.$anonfun$doWriteValue$4(this, first, param);
                    return BoxedUnit.UNIT;
                });
                this.writer().write(") -> ???");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (this.isDateValue(value, ctx)) {
                this.writer().write("|");
                this.writer().write(StringType$.MODULE$.coerce(v, ctx).evaluate(ctx).toString());
                this.writer().write("|");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (RegexType$.MODULE$.accepts(value, ctx)) {
                this.writer().write("/");
                String regex = ((Regex)RegexType$.MODULE$.coerce(v, ctx).evaluate(ctx)).regex();
                regex = regex.replaceAll("\\/", "\\\\/");
                this.writer().write(regex);
                this.writer().write("/");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (NamespaceType$.MODULE$.accepts(value, ctx)) {
                this.writeValue(ObjectType$.MODULE$.coerce(v, ctx), ctx);
                this.writer().write("as Namespace");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (BinaryType$.MODULE$.accepts(value, ctx)) {
                String base64String = BinaryHelper$.MODULE$.toBase64String((SeekableStream)BinaryType$.MODULE$.coerce(v, ctx).evaluate(ctx), ctx.serviceManager().memoryService());
                this.writeQuoteString(base64String);
                Schema newSchema = Schema$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SchemaProperty[]{SchemaProperty$.MODULE$.apply((Value)StringValue$.MODULE$.apply(Schema$.MODULE$.BASE_PROPERTY_NAME()), (Value)StringValue$.MODULE$.apply("64"))})));
                this.writeSchema((Type)BinaryType$.MODULE$, (Option<Schema>)new Some((Object)newSchema), ctx);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (StringType$.MODULE$.accepts(value, ctx)) {
                String strValue = StringType$.MODULE$.coerce(v, ctx).evaluate(ctx).toString();
                this.writeQuoteString(strValue);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                String strValue = StringType$.MODULE$.coerce(v, ctx).evaluate(ctx).toString();
                this.writeQuoteString(strValue);
                ignoreSchema = true;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            if (ignoreSchema) break block31;
            this.writeSchema(v.valueType(ctx), (Option<Schema>)v.schema(ctx), ctx);
        }
    }

    private String getUniquePrefix(Namespace namespace) {
        return this.getPrefixFor(namespace.prefix(), namespace.uri());
    }

    private boolean isDateValue(Value<?> v, EvaluationContext ctx) {
        return DateTimeType$.MODULE$.accepts(v, ctx) || LocalDateType$.MODULE$.accepts(v, ctx) || PeriodType$.MODULE$.accepts(v, ctx) || LocalDateTimeType$.MODULE$.accepts(v, ctx) || TimeType$.MODULE$.accepts(v, ctx) || LocalTimeType$.MODULE$.accepts(v, ctx) || TimeZoneType$.MODULE$.accepts(v, ctx);
    }

    private Seq<Namespace> collectUndeclaredNS(Seq<KeyValuePair> valuePairs, EvaluationContext ctx) {
        return (Seq)((SeqLike)((TraversableLike)valuePairs.flatMap((Function1 & Serializable & scala.Serializable)kvp -> {
            TraversableOnce traversableOnce;
            Value key = kvp._1();
            QualifiedName keyName = (QualifiedName)key.evaluate(ctx);
            Option mayBeAttributes = AttributeHelper$.MODULE$.attributes(key, ctx);
            Option option = mayBeAttributes;
            if (option instanceof Some) {
                Some some = (Some)option;
                Value attributes = (Value)some.value();
                traversableOnce = ((NameSeq)attributes.evaluate(ctx)).toIterator().flatMap((Function1 & Serializable & scala.Serializable)nvp -> Option$.MODULE$.option2Iterable(((QualifiedName)nvp._1().evaluate(ctx)).namespace().flatMap((Function1 & Serializable & scala.Serializable)qname -> this.alreadyDefined((Namespace)qname) ? None$.MODULE$ : new Some(qname))));
            } else if (None$.MODULE$.equals(option)) {
                traversableOnce = (TraversableOnce)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            } else {
                throw new MatchError((Object)option);
            }
            TraversableOnce missingAttributesNS = traversableOnce;
            Option missingNS = keyName.namespace().flatMap((Function1 & Serializable & scala.Serializable)qname -> this.alreadyDefined((Namespace)qname) ? None$.MODULE$ : new Some(qname));
            return missingNS.isDefined() ? (TraversableOnce)missingAttributesNS.toSeq().$colon$plus(missingNS.get(), Seq$.MODULE$.canBuildFrom()) : missingAttributesNS;
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)WeaveWriter.$anonfun$collectUndeclaredNS$5(x$6)))).distinct();
    }

    private void writeQuoteString(String strValue) {
        this.writer().write(StringEscapeHelper$.MODULE$.escapeString(strValue, StringEscapeHelper$.MODULE$.escapeString$default$2(), StringEscapeHelper$.MODULE$.escapeString$default$3()));
    }

    public void flush() {
        this.writer().flush();
    }

    public Option<DataFormat<?, ?>> dataFormat() {
        return new Some((Object)new WeaveDataFormat());
    }

    public static final /* synthetic */ boolean $anonfun$getPrefixFor$2(String uri$1, Namespace x$2) {
        String string = x$2.uri();
        String string2 = uri$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getPrefixFor$3(ObjectRef tmpPrefix$1, Namespace x$3) {
        String string = x$3.prefix();
        String string2 = (String)tmpPrefix$1.elem;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$writeNamespace$1(String prefix$1, Namespace x$4) {
        String string = x$4.prefix();
        String string2 = prefix$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$writeSchema$1(WeaveWriter $this, BooleanRef first$1, EvaluationContext ctx$1, SchemaProperty sproperty) {
        block0: {
            if (sproperty.internal()) break block0;
            Object object = !first$1.elem ? $this.writer().append((CharSequence)", ") : BoxedUnit.UNIT;
            $this.writer().append((CharSequence)sproperty.name().evaluate(ctx$1));
            $this.writer().write(": ");
            $this.writeValue(sproperty.value(), ctx$1);
            first$1.elem = false;
        }
    }

    public static final /* synthetic */ void $anonfun$qualifiedName$1(WeaveWriter $this, BooleanRef first$2, EvaluationContext ctx$2, NameValuePair nvp) {
        if (!first$2.elem) {
            $this.writer().write(", ");
        }
        $this.qualifiedName((Value<QualifiedName>)nvp._1(), (Option<Value<NameSeq>>)None$.MODULE$, ctx$2);
        $this.writer().write(": ");
        $this.writeValue(nvp._2(), ctx$2);
        first$2.elem = false;
    }

    public static final /* synthetic */ boolean $anonfun$alreadyDefined$2(Namespace ns$1, Namespace x$5) {
        String string = x$5.uri();
        String string2 = ns$1.uri();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$doWriteValue$1(WeaveWriter $this, BooleanRef first$3, EvaluationContext ctx$3, Value v2) {
        if (!first$3.elem) {
            $this.writer().write(", ");
            $this.newline();
        }
        $this.writeValue(v2, ctx$3);
        first$3.elem = false;
    }

    public static final /* synthetic */ void $anonfun$doWriteValue$3(WeaveWriter $this, BooleanRef first$4, EvaluationContext ctx$3, KeyValuePair ekv) {
        if (!first$4.elem) {
            $this.writer().write(",");
            $this.newline();
        }
        $this.qualifiedName((Value<QualifiedName>)ekv._1(), (Option<Value<NameSeq>>)AttributeHelper$.MODULE$.attributes(ekv._1(), ctx$3), ctx$3);
        $this.writer().write(": ");
        $this.writeValue(ekv._2(), ctx$3);
        first$4.elem = false;
    }

    public static final /* synthetic */ void $anonfun$doWriteValue$4(WeaveWriter $this, BooleanRef first$5, FunctionParameter param) {
        Object object = !first$5.elem ? $this.writer().append((CharSequence)", ") : BoxedUnit.UNIT;
        $this.writer().write(param.name());
        $this.writer().write(":");
        $this.writer().write(param.wtype().name());
        first$5.elem = false;
    }

    public static final /* synthetic */ boolean $anonfun$collectUndeclaredNS$5(Namespace x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6.uri())).nonEmpty();
    }

    public WeaveWriter(OutputStream os, WeaveWriterSettings settings, EvaluationContext ctx) {
        this.os = os;
        this.settings = settings;
        ConfigurableReaderWriter.$init$((ConfigurableReaderWriter)this);
        Writer.$init$((Writer)this);
        this.declaredNs = (Stack)Stack$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.insideHeader = false;
        this.indent = 0;
    }
}

