%dw 2.0
output application/json
import * from dw::core::Strings
import * from dw::Runtime

// Test cases that would fail with Character.toChars()
var invalidCases = [
    -1,                    // Negative code point
    1114112,              // Beyond maximum Unicode (0x10FFFF)
    55296,                // High surrogate (0xD800)
    57343
]

// Test cases that work with both approaches
var validCases = [
    65,                   // 'A' - BMP character
    156609               // '𦏁' - Supplementary character
]


---
    (validCases ++ invalidCases) map {
                                  surrogateChar: (try(() -> fromCharCode($)) orElse "Error"),
                                  surrogateCodePoint: (try(() -> charCode(fromCharCode($))) orElse -1)
                                  }
