package org.mule.weave.v2.runtime.core.functions.math

import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.NumberType
import org.mule.weave.v2.model.values.math.Number
import org.mule.weave.v2.model.values.NumberValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.runtime.core.exception.DivisionByZeroException

object ModuleNumberFunctionValue extends BinaryFunctionValue {

  override val L = NumberType

  override val R = NumberType

  override def doExecute(leftValue: L.V, rightValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    try {
      val result = Number(leftValue.evaluate.toBigDecimal.%(rightValue.evaluate.toBigDecimal))
      NumberValue(result, this)
    } catch {
      case _: java.lang.ArithmeticException => throw new DivisionByZeroException(this.location)
    }
  }

}
