package org.mule.weave.v2.interpreted.debugger.server

import org.mule.weave.v2.debugger.WeaveBreakpoint
import org.mule.weave.v2.debugger.WeaveExceptionBreakpoint
import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.parser.ast.WeaveLocationCapable

/**
  * Handles all breakpoints
  */
trait WeaveBreakpointManager {

  /**
    * Test if a breakpoint exists in the given location
    * @param location The location where to validate
    * @param ctx The context
    * @return True if it exists
    */
  def hasBreakpointOn(location: WeaveLocationCapable)(implicit ctx: ExecutionContext): Boolean

  /**
    * Adds a new breakpoint
    *
    * @param breakpoint The breakpoint to be added
    */
  def addBreakpoint(breakpoint: WeaveBreakpoint): Unit

  /**
    * Removes the given breakpoint
    * @param breakpoint The breakpoint to be removed
    */
  def removeBreakpoint(breakpoint: WeaveBreakpoint): Unit

  /**
    * Remove all breakpoints
    */
  def clearBreakpoints(): Unit

  /**
    * Returns true if it has Exception Breakpoint for
    */
  def hasExceptionBreakpoint(e: Exception): Boolean

  /**
    * Returns true if it has Exception Breakpoint for
    */
  def addExceptionBreakpoint(e: WeaveExceptionBreakpoint): Unit

  /**
    * Returns true if it has Exception Breakpoint for
    */
  def removeExceptionBreakpoint(e: WeaveExceptionBreakpoint): Unit
}
