package org.mule.weave.v2.interpreted.node

import org.mule.weave.v2.core.exception._
import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.model.values.NullValue
import org.mule.weave.v2.model.values.Value

class NullSafeNode(selector: ValueNode[_]) extends ValueNode[Any] with Product1[ValueNode[_]] {

  override def _1: ValueNode[_] = selector

  override def doExecute(implicit executionContext: ExecutionContext): Value[_] = {
    try {
      selector.execute
    } catch {
      case _: InvalidSelectionException => NullValue
    }
  }

}

object NullSafeNode {
  def apply(selector: ValueNode[_]) = new NullSafeNode(selector)
}
