package org.mule.weave.v2.runtime.core.functions.collections

import org.mule.weave.v2.core.functions.UnaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.ArrayType
import org.mule.weave.v2.model.types.ObjectType
import org.mule.weave.v2.model.types.StringType
import org.mule.weave.v2.model.values.BooleanValue
import org.mule.weave.v2.model.values.Value

object EmptyStringFunctionValue extends UnaryFunctionValue {
  override val R = StringType

  override def doExecute(v: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    BooleanValue(v.evaluate.toString.isEmpty)
  }
}

object EmptyArrayFunctionValue extends UnaryFunctionValue {
  override val R = ArrayType

  override def doExecute(v: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    BooleanValue(v.evaluate.isEmpty)
  }
}

object EmptyObjectFunctionValue extends UnaryFunctionValue {
  override val R = ObjectType

  override def doExecute(v: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    BooleanValue(v.evaluate.isEmpty)
  }
}

