package org.mule.weave.v2.runtime.core.functions.stringops

import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.capabilities.UnknownLocationCapable
import org.mule.weave.v2.model.structure.ArraySeq
import org.mule.weave.v2.model.types.RegexType
import org.mule.weave.v2.model.types.StringType
import org.mule.weave.v2.model.values.ArrayValue
import org.mule.weave.v2.model.values.NullValue
import org.mule.weave.v2.model.values.StringValue
import org.mule.weave.v2.model.values.Value

import java.util.regex.Matcher
import java.util.regex.Pattern
import scala.collection.mutable.ArrayBuffer

object StringScanFunctionValue extends BinaryFunctionValue {
  override val L = StringType
  override val R = RegexType

  override def doExecute(leftValue: L.V, rightValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    val resultBuilder = new ArrayBuffer[ArrayValue]
    val pattern: Pattern = rightValue.evaluate.pattern
    val matcher: Matcher = ctx.serviceManager.patternService.matcher(pattern, leftValue.evaluate, this)
    while (matcher.find()) {
      val matchBuilder = new ArrayBuffer[Value[_]]
      val count: Int = matcher.groupCount()
      var index = 0
      while (index <= count) {
        val group: String = matcher.group(index)
        matchBuilder.+=(toValue(group))
        index = index + 1
      }
      resultBuilder += ArrayValue(matchBuilder.result(), UnknownLocationCapable)
    }
    ArrayValue(ArraySeq(resultBuilder.result()), UnknownLocationCapable)
  }

  private def toValue(group: String): Value[_] = {
    if (group == null) NullValue else StringValue(group, this)
  }
}

object ScanFunctionValue {
  val value = Seq(StringScanFunctionValue)
}
