package org.mule.weave.v2.interpreted.exception

import org.mule.weave.v2.core.functions.WriteFunctionValue
import org.mule.weave.v2.core.exception.ExecutionException
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.parser.location.Location

class InvalidIfConditionException(value: Value[_], override val location: Location)(implicit ctx: EvaluationContext) extends ExecutionException {
  override def message: String = s"Invalid if condition type. Expecting type `Boolean` but got `${value.valueType.name}(${WriteFunctionValue.toDwString(value, WriteFunctionValue.maxValueLength)})`"
}
