package org.mule.weave.v2.runtime.core.functions

import org.mule.weave.v2.core.functions.UnaryFunctionValue
import org.mule.weave.v2.core.exception.UserException
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.StringType
import org.mule.weave.v2.model.types.Type
import org.mule.weave.v2.model.values._

object FailFunctionValue extends UnaryFunctionValue {

  override val R: Type = StringType
  override val rightDefaultValue: Option[ValueProvider] = Some(ValueProvider(StringValue("")))

  override def doExecute(message: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    throw new UserException(location(), StringType.coerce(message, this).evaluate.toString)
  }
}
