package org.mule.weave.v2.runtime.utils

import java.util.ServiceLoader

import scala.collection.JavaConverters._

trait CustomRunner {

  type T

  def runnerName(): String

  def parseArgs(args: Array[String]): Either[T, String]

  def usage()

  def run(config: T)

}

object CustomRunner {
  private val runners = ServiceLoader.load(classOf[CustomRunner], classOf[CustomRunner].getClassLoader).asScala.toSeq

  def runnerByName(name: String): Option[CustomRunner] = {
    runners.find(_.runnerName().equals(name))
  }

  def customRunners = runners
}
