package org.mule.weave.v2.interpreted.node.structure

import org.mule.weave.v2.interpreted.node.BinaryOpNode
import org.mule.weave.v2.interpreted.node.ChainedBinaryOpNode
import org.mule.weave.v2.interpreted.node.ValueNode
import org.mule.weave.v2.interpreted.node.executors.BinaryOpExecutor
import org.mule.weave.v2.model.types.StringType
import org.mule.weave.v2.parser.location.UnknownLocation
import org.mule.weave.v2.runtime.core.functions.collections.StringAppendStringFunctionValue
import org.mule.weave.v2.runtime.core.operator.conversion.AsFunctionValue

object StringInterpolationNode {
  def apply(v: Seq[ValueNode[_]]): ValueNode[_] = {
    v.size match {
      case 1 => {
        val opExecutor = new BinaryOpExecutor(
          Array(new AsFunctionValue(v.head.location(), false)),
          "",
          v.head.location(),
          false,
          true)
        new BinaryOpNode(opExecutor, v.head, new TypeNode(StringType, None))
      }
      case 0 => {
        new StringNode("")
      }
      case _ => {
        new ChainedBinaryOpNode((0 to v.size - 2).map((_) => {
          new BinaryOpExecutor(Array(StringAppendStringFunctionValue), "Append", UnknownLocation, false, false)
        }).toArray, v.toArray)
      }
    }
  }
}
