package org.mule.weave.v2.runtime.core.functions

import org.mule.weave.v2.model.values.FunctionValue
import org.mule.weave.v2.model.values.NativeFunctionUtils.putInto
import org.mule.weave.v2.runtime.core.functions.stringops.IsAlphaNumericStringFunctionValue
import org.mule.weave.v2.runtime.core.functions.stringops.IsAlphaStringFunctionValue
import org.mule.weave.v2.runtime.core.functions.stringops.IsLowerCaseStringFunctionValue
import org.mule.weave.v2.runtime.core.functions.stringops.IsNumericStringFunctionValue
import org.mule.weave.v2.runtime.core.functions.stringops.IsUpperCaseStringFunctionValue
import org.mule.weave.v2.runtime.core.functions.stringops.IsWhitespaceStringFunctionValue
import org.mule.weave.v2.runtime.core.functions.stringops.NumberOrdinalizeFunctionValue
import org.mule.weave.v2.runtime.core.functions.stringops.ReplaceStringRegexFunctionValue
import org.mule.weave.v2.runtime.core.functions.stringops.ReplaceStringStringFunctionValue
import org.mule.weave.v2.runtime.core.functions.stringops.StringCamelizeFunctionValue
import org.mule.weave.v2.runtime.core.functions.stringops.StringCapitalizeFunctionValue
import org.mule.weave.v2.runtime.core.functions.stringops.StringDasherizeFunctionValue
import org.mule.weave.v2.runtime.core.functions.stringops.StringEndsWithFunctionValue
import org.mule.weave.v2.runtime.core.functions.stringops.StringLowerFunctionValue
import org.mule.weave.v2.runtime.core.functions.stringops.StringMatchesFunctionValue
import org.mule.weave.v2.runtime.core.functions.stringops.StringParseUrlFunctionValue
import org.mule.weave.v2.runtime.core.functions.stringops.StringPluralizeOperator
import org.mule.weave.v2.runtime.core.functions.stringops.StringRegexMatchFunctionValue
import org.mule.weave.v2.runtime.core.functions.stringops.StringScanFunctionValue
import org.mule.weave.v2.runtime.core.functions.stringops.StringSingularizeFunctionValue
import org.mule.weave.v2.runtime.core.functions.stringops.StringSplitRegexFunctionValue
import org.mule.weave.v2.runtime.core.functions.stringops.StringSplitStringFunctionValue
import org.mule.weave.v2.runtime.core.functions.stringops.StringStartsWithFunctionValue
import org.mule.weave.v2.runtime.core.functions.stringops.StringTrimFunctionValue
import org.mule.weave.v2.runtime.core.functions.stringops.StringUnderscoreFunctionValue
import org.mule.weave.v2.runtime.core.functions.stringops.StringUpperFunctionValue
import org.mule.weave.v2.runtime.core.functions.stringops.StringUrlDecodeComponentFunctionValue
import org.mule.weave.v2.runtime.core.functions.stringops.StringUrlDecodeFunctionValue
import org.mule.weave.v2.runtime.core.functions.stringops.StringUrlEncodeComponentFunctionValue
import org.mule.weave.v2.runtime.core.functions.stringops.StringUrlEncodeFunctionValue

import scala.collection.mutable
/**
  * Registers all the functions for the dw::core::Strings module
  */
object StringsNativeFunctions {

  def registerFunction(catalog: mutable.Map[String, FunctionValue]): Unit = {
    {
      putInto(StringCamelizeFunctionValue, catalog)
      putInto(StringCapitalizeFunctionValue, catalog)
      putInto(StringDasherizeFunctionValue, catalog)
      putInto(StringEndsWithFunctionValue, catalog)
      putInto(StringLowerFunctionValue, catalog)
      putInto(StringMatchesFunctionValue, catalog)
      putInto(NumberOrdinalizeFunctionValue, catalog)
      putInto(StringScanFunctionValue, catalog)
      putInto(StringSplitStringFunctionValue, catalog)
      putInto(StringSplitRegexFunctionValue, catalog)
      putInto(StringStartsWithFunctionValue, catalog)
      putInto(StringTrimFunctionValue, catalog)
      putInto(StringUnderscoreFunctionValue, catalog)
      putInto(StringUpperFunctionValue, catalog)
      putInto(StringRegexMatchFunctionValue, catalog)
      putInto(StringPluralizeOperator, catalog)
      putInto(StringSingularizeFunctionValue, catalog)
      putInto(StringUrlEncodeFunctionValue, catalog)
      putInto(StringUrlEncodeComponentFunctionValue, catalog)
      putInto(StringUrlDecodeFunctionValue, catalog)
      putInto(StringUrlDecodeComponentFunctionValue, catalog)
      putInto(StringParseUrlFunctionValue, catalog)
      putInto(ReplaceStringRegexFunctionValue, catalog)
      putInto(ReplaceStringStringFunctionValue, catalog)
      putInto(IsWhitespaceStringFunctionValue, catalog)
      putInto(IsNumericStringFunctionValue, catalog)
      putInto(IsAlphaStringFunctionValue, catalog)
      putInto(IsAlphaNumericStringFunctionValue, catalog)
      putInto(IsUpperCaseStringFunctionValue, catalog)
      putInto(IsLowerCaseStringFunctionValue, catalog)
    }
  }
}
