%dw 2.0
output application/json

import * from dw::Runtime
import dw::core::Binaries

fun decodeInputs(inputs) =
  inputs mapObject ((value, key, index) ->
      (key): value  update {
              case content at .value -> if(value.kind == "binary") Binaries::fromBase64(content) else content as Binary {encoding: "UTF-8"}
              case encoding at .encoding! if(value.kind == "text") -> "UTF-8"
      })

var result = run(in0.main, in0.fs, decodeInputs(in0.inputs), {}, {timeOut: 5000, securityManager: (grant, args) -> false})
---
{
  success: result.success,
  error: {
    kind: result.error.kind,
    messageOk: result.error.message contains "Unable to resolve reference to Lazy"
  }
}