package org.mule.weave.v2.runtime.core.functions.crypto

import java.security.MessageDigest
import java.security.NoSuchAlgorithmException

import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.core.exception.UnknownAlgorithmException
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.BinaryType
import org.mule.weave.v2.model.types.StringType
import org.mule.weave.v2.model.values._

object HashFunctionValue extends BinaryFunctionValue {

  override val L = BinaryType

  override val R = StringType

  override val rightDefaultValue: Option[ValueProvider] = Some(ValueProvider(StringValue("SHA-1")))

  override def doExecute(contentValue: L.V, algorithmValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    val content: Array[Byte] = BinaryValue.getBytesFromSeekableStream(contentValue.evaluate, ctx.serviceManager.memoryService)
    val algorithm: String = algorithmValue.evaluate(ctx).toString
    try {
      BinaryValue(MessageDigest.getInstance(algorithm).digest(content))
    } catch {
      case e: NoSuchAlgorithmException => throw new UnknownAlgorithmException(algorithmValue.location(), e.getMessage)
    }
  }
}
