package org.mule.weave.v2.runtime.core.operator.equality

import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.AnyType
import org.mule.weave.v2.model.types.TypeType
import org.mule.weave.v2.model.values.BooleanValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.parser.location.WeaveLocation

class IsOperator(override val location: WeaveLocation) extends BinaryFunctionValue {
  override val L = AnyType

  override val R = TypeType

  override def doExecute(leftValue: L.V, rightValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    BooleanValue(rightValue.evaluate.accepts(leftValue), this)
  }
}

