package org.mule.weave.v2.runtime.core.functions

import org.mule.weave.v2.model.values.FunctionValue
import org.mule.weave.v2.model.values.NativeFunctionUtils.putInto
import org.mule.weave.v2.runtime.core.functions.runtime.DataFormatDescriptorsFunctionValue
import org.mule.weave.v2.runtime.core.functions.runtime.EvalScriptFunctionValue
import org.mule.weave.v2.runtime.core.functions.runtime.FindDataFormatDescriptorByMimeFunctionValue
import org.mule.weave.v2.runtime.core.functions.runtime.RunScriptFunctionValue

import scala.collection.mutable

/**
  * Registers all the functions for the dw::Runtime module
  */
object RuntimeNativeFunctions {

  def registerFunction(catalog: mutable.Map[String, FunctionValue]): Unit = {
    {
      putInto(RunScriptFunctionValue, catalog)
      putInto(EvalScriptFunctionValue, catalog)
      putInto(DataFormatDescriptorsFunctionValue, catalog)
      putInto(FindDataFormatDescriptorByMimeFunctionValue, catalog)
    }
  }

}
