%dw 2.0
import * from dw::Runtime
import * from dw::module::Mime
output application/json

var headers = {
 "Content-Type": "application/xml"
}

var JSON = {'type': "application", subtype: "json", parameters: {}}
var MULTIPART = {'type': "multipart", subtype: "form-data", parameters: {boundary: "my-boundary"}}
var ALL = {'type': "*", subtype: "*", parameters: {}}
---
{
  a: fromString("application/json"),
  b: fromString(headers."Content-Type"),
  c: fromString("application/protobuf"),
  d: fromString("multipart/form-data; boundary=the-boundary"),
  e: fromString("*/*").result,
  f: fromString("Invalid MIME type"),
  g: toString(JSON),
  h: toString(MULTIPART),
  i: toString(fromString("application/octet-stream").result!),
  j: isHandledBy(JSON, JSON),
  k: isHandledBy({'type': "*", subtype: "json", parameters: {}}, JSON),
  l: isHandledBy({'type': "application", subtype: "*", parameters: {}}, JSON),
  m: isHandledBy(ALL, MULTIPART),
  n: isHandledBy(MULTIPART, ALL),
  o: isHandledBy(JSON, MULTIPART),
  p: isHandledBy(
    {'type': "application", subtype: "*+xml", parameters: {}},
    {'type': "application", subtype: "soap+xml", parameters: {}})
}