package org.mule.weave.v2.interpreted.node.expressions

import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.interpreted.node.ValueNode
import org.mule.weave.v2.model.values.Value

class TailRecFunctionBodyNode(block: ValueNode[_]) extends ValueNode[Any] with Product1[ValueNode[_]] {
  override protected def doExecute(implicit ctx: ExecutionContext): Value[Any] = {
    var result: Value[_] = null
    while (result == null) {
      try {
        result = block.execute
      } catch {
        case up: ReturnVariablesException => {
          val variables = up.variables
          var i = 0
          while (i < variables.length) {
            val tuple = variables(i)
            ctx.executionStack().setVariable(tuple._1.slot, tuple._2)
            i = i + 1
          }
        }
      }
    }
    result
  }

  override def _1: ValueNode[_] = block
}
