package org.mule.weave.v2.runtime.core.functions

import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.core.functions.WriteFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.AnyType
import org.mule.weave.v2.model.types.StringType
import org.mule.weave.v2.model.values._

object LogFunctionValue extends BinaryFunctionValue {

  override val L = StringType

  override val leftDefaultValue: Option[ValueProvider] = Some(ValueProvider(StringValue("")))

  override val R = AnyType

  override def doExecute(prefixValueMaybe: L.V, messageValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    val logger = ctx.serviceManager.loggingService
    if (logger.isInfoEnabled()) {
      val messageValueMat = messageValue.materialize
      val writer = WriteFunctionValue
      val logValue = writer.call(messageValueMat, writer.secondDefaultValue.get.value(), writer.thirdDefaultValue.get.value())
      val messageString: String = StringType.coerce(logValue, this).evaluate.toString
      val message: String = prefixValueMaybe.evaluate.toString match {
        case prefix if prefix.nonEmpty => prefix + " - " + messageString
        case _                         => messageString
      }
      logger.logInfo(message)
      messageValueMat
    } else {
      messageValue
    }
  }
}
