package org.mule.weave.v2.runtime.core.functions.runtime

import org.mule.weave.v2.core.functions.UnaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.ObjectSeq
import org.mule.weave.v2.model.types.ObjectType
import org.mule.weave.v2.model.values.NullValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.module.DataFormatManager
import org.mule.weave.v2.runtime.core.functions.mime.MimeTypeConverter

object FindDataFormatDescriptorByMimeFunctionValue extends UnaryFunctionValue {

  override val R = ObjectType

  override protected def doExecute(v: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    val mimeTypeObjectSeq: ObjectSeq = v.evaluate.materialize()
    val mimeType = MimeTypeConverter.toMimeType(mimeTypeObjectSeq)
    DataFormatManager
      .byContentType(mimeType)
      .map(df => {
        DataFormatDescriptorConverter.toObjectValue(df)
      }).getOrElse(NullValue)
  }
}
