package org.mule.weave.v2.runtime.core.operator.math

import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.NumberType
import org.mule.weave.v2.model.values.NumberValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.model.values.math
import org.mule.weave.v2.parser.location.WeaveLocation
import org.mule.weave.v2.runtime.core.exception.DivisionByZeroException

class NumberDivisionOperator(override val location: WeaveLocation) extends BinaryFunctionValue {

  override val L = NumberType

  override val R = NumberType

  override def doExecute(leftValue: L.V, rightValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    val leftNumber = leftValue.evaluate
    val rightNumber = rightValue.evaluate
    NumberValue(doDivision(leftNumber, rightNumber), this)
  }

  def doDivision(leftNumber: math.Number, rightNumber: math.Number): math.Number = {
    try {
      leftNumber / rightNumber
    } catch {
      case _: IllegalArgumentException      => throw new DivisionByZeroException(this.location)
      case _: java.lang.ArithmeticException => throw new DivisionByZeroException(this.location)
    }
  }
}
