package org.mule.weave.v2.interpreted.transform

import org.mule.weave.v2.interpreted.node.NameSlot
import org.mule.weave.v2.interpreted.node.structure.header.directives.ImportDirective
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.AstNodeHelper
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode
import org.mule.weave.v2.parser.ast.structure.NamespaceNode
import org.mule.weave.v2.parser.ast.types.TypeReferenceNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.parser.ast.variables.VariableReferenceNode
import org.mule.weave.v2.parser.exception.WeaveRuntimeException

trait EngineImportTransformations extends AstTransformation with EngineVariableTransformations with EngineHeaderTransformations {

  def transformImportDirectives(root: AstNode): Seq[ImportDirective] = {
    val variableReference: Seq[VariableReferenceNode] = AstNodeHelper.collectChildrenWith(root, classOf[VariableReferenceNode])
    val typeReference: Seq[TypeReferenceNode] = AstNodeHelper.collectChildrenWith(root, classOf[TypeReferenceNode])
    val namespaces: Seq[NamespaceNode] = AstNodeHelper.collectChildrenWith(root, classOf[NamespaceNode])
    val annotations: Seq[AnnotationNode] = AstNodeHelper.collectChildrenWith(root, classOf[AnnotationNode])

    val importedModules: Seq[NameIdentifier] = variableReference.flatMap((vr) => {
      val reference = scopeNavigator().resolveVariable(vr.variable)
      reference.flatMap(_.moduleSource)
    }) ++
      typeReference.flatMap((tr) => {
        val reference = scopeNavigator().resolveVariable(tr.variable)
        reference.flatMap(_.moduleSource)
      }) ++
      namespaces.flatMap((tr) => {
        val reference = scopeNavigator().resolveVariable(tr.prefix)
        reference.flatMap(_.moduleSource)
      }) ++
      annotations.flatMap((tr) => {
        val reference = scopeNavigator().resolveVariable(tr.name)
        reference.flatMap(_.moduleSource)
      })

    val distinctModules = importedModules.distinct
    distinctModules.map((moduleName) => {
      val theParsingContext = parsingContext()
      val nodeLoader = moduleLoader()
      val maybeNode = nodeLoader.compile(moduleName, theParsingContext)
      val module = maybeNode.getOrElse(throw new WeaveRuntimeException(s"Unable to load module ${moduleName.name}", moduleName.location()))
      val moduleSlot: NameSlot = createModuleSlot(moduleName.name)
      _modules.insert(moduleSlot.slot, module.variableTable)
      new ImportDirective(moduleSlot, module)
    })
  }

}
