package org.mule.weave.v2.runtime

import org.mule.weave.v2.interpreted.InterpreterMappingCompilerPhase
import org.mule.weave.v2.interpreted.InterpreterModuleCompilerPhase
import org.mule.weave.v2.interpreted.RuntimeModuleNodeCompiler
import org.mule.weave.v2.interpreted.transform.phase.ConstantFoldingPhase
import org.mule.weave.v2.parser.MappingParser
import org.mule.weave.v2.parser.ModuleParser
import org.mule.weave.v2.parser.ast.module.ModuleNode
import org.mule.weave.v2.parser.ast.structure.DocumentNode
import org.mule.weave.v2.parser.phase.CommonSubexpressionReductionPhase
import org.mule.weave.v2.parser.phase.CompilationPhase
import org.mule.weave.v2.parser.phase.ParsingContentInput
import org.mule.weave.v2.parser.phase.ParsingContext
import org.mule.weave.v2.parser.phase.PhaseResult
import org.mule.weave.v2.sdk.WeaveResource

object WeaveCompiler {

  private def fullCompilerPhase(moduleNodeLoader: RuntimeModuleNodeCompiler): CompilationPhase[ParsingContentInput, CompilationResult[DocumentNode]] = {
    MappingParser.typeCheckPhase()
      .chainWith(new CommonSubexpressionReductionPhase[DocumentNode]())
      .chainWith(new ConstantFoldingPhase[DocumentNode]())
      .chainWith(new InterpreterMappingCompilerPhase(moduleNodeLoader))
  }

  private def fullModuleCompilerPhase(moduleNodeLoader: RuntimeModuleNodeCompiler): CompilationPhase[ParsingContentInput, CompilationResult[ModuleNode]] = {
    ModuleParser.typeCheckPhase()
      .chainWith(new CommonSubexpressionReductionPhase[ModuleNode]())
      .chainWith(new ConstantFoldingPhase[ModuleNode]())
      .chainWith(new InterpreterModuleCompilerPhase(moduleNodeLoader))
  }

  private def noCheckCompilerPhase(moduleNodeLoader: RuntimeModuleNodeCompiler): CompilationPhase[ParsingContentInput, CompilationResult[DocumentNode]] = {
    MappingParser.scopePhase()
      .chainWith(new CommonSubexpressionReductionPhase[DocumentNode]())
      .chainWith(new ConstantFoldingPhase[DocumentNode]())
      .chainWith(new InterpreterMappingCompilerPhase(moduleNodeLoader))
  }

  def compileWithNoCheck(input: WeaveResource, parsingContext: ParsingContext, moduleNodeLoader: RuntimeModuleNodeCompiler): PhaseResult[CompilationResult[DocumentNode]] = {
    MappingParser
      .parse(noCheckCompilerPhase(moduleNodeLoader), input, parsingContext)
  }

  def compileWithNoCheck(input: WeaveResource, parsingContext: ParsingContext): PhaseResult[CompilationResult[DocumentNode]] = {
    MappingParser.parse(noCheckCompilerPhase(RuntimeModuleNodeCompiler()), input, parsingContext)
  }

  def compile(input: WeaveResource, parsingContext: ParsingContext): PhaseResult[CompilationResult[DocumentNode]] = {
    MappingParser.parse(fullCompilerPhase(RuntimeModuleNodeCompiler()), input, parsingContext)
  }

  def compile(input: WeaveResource, parsingContext: ParsingContext, moduleNodeLoader: RuntimeModuleNodeCompiler): PhaseResult[CompilationResult[DocumentNode]] = {
    MappingParser.parse(fullCompilerPhase(moduleNodeLoader), input, parsingContext)
  }

  def compileModule(input: WeaveResource, parsingContext: ParsingContext, moduleNodeLoader: RuntimeModuleNodeCompiler): PhaseResult[CompilationResult[ModuleNode]] = {
    ModuleParser.parse(fullModuleCompilerPhase(moduleNodeLoader), input, parsingContext)
  }
}
