package org.mule.weave.v2.interpreted.node.structure.header.directives

import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.interpreted.Frame
import org.mule.weave.v2.interpreted.node.NameSlot
import org.mule.weave.v2.interpreted.node.ValueNode
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.model.values.wrappers.LazyValue

final class LazyVarDirective(val variable: NameSlot, val literal: ValueNode[_], val materialize: Boolean) extends Directive with Product2[NameSlot, ValueNode[_]] {

  override def execute(implicit ctx: ExecutionContext): Unit = {
    val frame: Frame = ctx.executionStack().activeFrame()
    ctx.executionStack().setVariable(variable.slot, LazyValue(initValue(ctx, frame), this))
  }

  private def initValue(ctx: ExecutionContext, frame: Frame): Value[_] = {
    ctx match {
      case ex: ExecutionContext => doInitialize(frame)(ex)
      case _ => {
        val ex: ExecutionContext = ExecutionContext(frame, ctx)
        doInitialize(frame)(ex)
      }
    }
  }

  private def doInitialize(frame: Frame)(implicit ex: ExecutionContext): Value[_] = {
    ex.runInFrame(frame, {
      if (materialize) {
        literal.execute(ex).materialize
      } else {
        literal.execute(ex)
      }
    })
  }

  override def _1: NameSlot = variable

  override def _2: ValueNode[_] = literal
}
