package org.mule.weave.v2.runtime.core.operator.selectors

import org.mule.weave.v2.core.functions.UnaryFunctionValue
import org.mule.weave.v2.core.exception.InvalidSelectionException
import org.mule.weave.v2.core.exception.NoAttributesDefinedException
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.ArraySeq
import org.mule.weave.v2.model.types.AnyType
import org.mule.weave.v2.model.types.ArrayType
import org.mule.weave.v2.model.values.ArrayValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.model.values.coercion.ArrayCoercer
import org.mule.weave.v2.model.values.helper.AttributeHelper
import org.mule.weave.v2.parser.location.WeaveLocation

class AllAttributesSelectorOperator(override val location: WeaveLocation) extends UnaryFunctionValue {
  override val R = AnyType

  override def doExecute(rightValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {

    rightValue match {
      case t if (ArrayType.accepts(t)) => {
        val array: ArraySeq = ArrayCoercer.coerceToArraySeq(rightValue)
        val attributes = array.toIterator().flatMap((v: Value[_]) => {
          val attributesAsObject = AttributeHelper.attributesAsObject(v)
          attributesAsObject match {
            case Some(o) if o.evaluate.isEmpty => None
            case value                         => value
          }
        })
        ArrayValue(attributes, this)
      }
      case _ => {
        val mayBeObject = AttributeHelper.attributesAsObject(rightValue)
        mayBeObject.getOrElse(throw InvalidSelectionException(new NoAttributesDefinedException(this.location)))
      }
    }
  }
}