/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.telemetry.service;

import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.dsl.Disruptor;
import java.io.Serializable;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.ServiceManager;
import org.mule.weave.v2.model.service.LoggingService;
import org.mule.weave.v2.model.service.RuntimeSettings$;
import org.mule.weave.v2.model.service.SettingsService;
import org.mule.weave.v2.parser.location.Location;
import org.mule.weave.v2.parser.location.WeaveLocation;
import org.mule.weave.v2.telemetry.service.DisruptorTelemetryEvent;
import org.mule.weave.v2.telemetry.service.DisruptorTelemetryEventFactory;
import org.mule.weave.v2.telemetry.service.FileTelemetryEventWriter;
import org.mule.weave.v2.telemetry.service.TelemetryEventHandler;
import org.mule.weave.v2.telemetry.service.TelemetryEventWriter;
import org.mule.weave.v2.telemetry.service.TelemetryService;
import org.mule.weave.v2.util.IntervalExecutor;
import scala.Array$;
import scala.Function0;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001B\f\u0019\u0001\u0015BQ\u0001\r\u0001\u0005\u0002EB\u0011b\r\u0001A\u0002\u0003\u0007I\u0011\u0002\u001b\t\u0013\r\u0003\u0001\u0019!a\u0001\n\u0013!\u0005\"\u0003&\u0001\u0001\u0004\u0005\t\u0015)\u00036\u0011%Y\u0005\u00011AA\u0002\u0013%A\nC\u0005R\u0001\u0001\u0007\t\u0019!C\u0005%\"IA\u000b\u0001a\u0001\u0002\u0003\u0006K!\u0014\u0005\n+\u0002\u0001\r\u00111A\u0005\nYC\u0011B\u0017\u0001A\u0002\u0003\u0007I\u0011B.\t\u0013u\u0003\u0001\u0019!A!B\u00139\u0006b\u00020\u0001\u0005\u0004%Ia\u0018\u0005\u0007M\u0002\u0001\u000b\u0011\u00021\t\u000f\u001d\u0004\u0001\u0019!C\u0005Q\"9A\u000e\u0001a\u0001\n\u0013i\u0007BB8\u0001A\u0003&\u0011\u000eC\u0003u\u0001\u0011\u0005Q\u000fC\u0003w\u0001\u0011\u0005q\u000fC\u0003y\u0001\u0011\u0005\u0011\u0010C\u0004\u0002\b\u0001!\t%!\u0003\t\u0013\u0005%\u0003!%A\u0005\u0002\u0005-\u0003bBA1\u0001\u0011\u0005\u00131\r\u0005\b\u0003K\u0002A\u0011IA2\u0005]!UMZ1vYR$V\r\\3nKR\u0014\u0018pU3sm&\u001cWM\u0003\u0002\u001a5\u000591/\u001a:wS\u000e,'BA\u000e\u001d\u0003%!X\r\\3nKR\u0014\u0018P\u0003\u0002\u001e=\u0005\u0011aO\r\u0006\u0003?\u0001\nQa^3bm\u0016T!!\t\u0012\u0002\t5,H.\u001a\u0006\u0002G\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\n\u0017\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\r\u0005s\u0017PU3g!\tic&D\u0001\u0019\u0013\ty\u0003D\u0001\tUK2,W.\u001a;ssN+'O^5dK\u00061A(\u001b8jiz\"\u0012A\r\t\u0003[\u0001\t\u0011\u0002Z5teV\u0004Ho\u001c:\u0016\u0003U\u00022A\u000e A\u001b\u00059$B\u0001\u001d:\u0003\r!7\u000f\u001c\u0006\u0003giR!a\u000f\u001f\u0002\t1l\u0017\r\u001f\u0006\u0002{\u0005\u00191m\\7\n\u0005}:$!\u0003#jgJ,\b\u000f^8s!\ti\u0013)\u0003\u0002C1\t9B)[:skB$xN\u001d+fY\u0016lW\r\u001e:z\u000bZ,g\u000e^\u0001\u000eI&\u001c(/\u001e9u_J|F%Z9\u0015\u0005\u0015C\u0005CA\u0014G\u0013\t9\u0005F\u0001\u0003V]&$\bbB%\u0004\u0003\u0003\u0005\r!N\u0001\u0004q\u0012\n\u0014A\u00033jgJ,\b\u000f^8sA\u0005aQ.\u001f*j]\u001e\u0014UO\u001a4feV\tQ\nE\u0002O\u001f\u0002k\u0011!O\u0005\u0003!f\u0012!BU5oO\n+hMZ3s\u0003Ai\u0017PU5oO\n+hMZ3s?\u0012*\u0017\u000f\u0006\u0002F'\"9\u0011JBA\u0001\u0002\u0004i\u0015!D7z%&twMQ;gM\u0016\u0014\b%A\u0006fm\u0016tGo\u0016:ji\u0016\u0014X#A,\u0011\u00055B\u0016BA-\u0019\u0005Q!V\r\\3nKR\u0014\u00180\u0012<f]R<&/\u001b;fe\u0006yQM^3oi^\u0013\u0018\u000e^3s?\u0012*\u0017\u000f\u0006\u0002F9\"9\u0011*CA\u0001\u0002\u00049\u0016\u0001D3wK:$xK]5uKJ\u0004\u0013\u0001\u00052vM\u001a,'OR;mY2{wmZ3s+\u0005\u0001\u0007CA1e\u001b\u0005\u0011'BA2\u001d\u0003\u0011)H/\u001b7\n\u0005\u0015\u0014'\u0001E%oi\u0016\u0014h/\u00197Fq\u0016\u001cW\u000f^8s\u0003E\u0011WO\u001a4fe\u001a+H\u000e\u001c'pO\u001e,'\u000fI\u0001\fS:LG/[1mSj,G-F\u0001j!\t9#.\u0003\u0002lQ\t9!i\\8mK\u0006t\u0017aD5oSRL\u0017\r\\5{K\u0012|F%Z9\u0015\u0005\u0015s\u0007bB%\u000f\u0003\u0003\u0005\r![\u0001\rS:LG/[1mSj,G\r\t\u0015\u0003\u001fE\u0004\"a\n:\n\u0005MD#\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u0015ILgn\u001a\"vM\u001a,'\u000fF\u0001N\u00035I7/\u00138ji&\fG.\u001b>fIR\t\u0011.\u0001\bj]&$\u0018J\u001a*fcVL'/\u001a3\u0015\u0003i$\"!R>\t\u000bq\u0014\u00029A?\u0002\u0007\r$\b\u0010E\u0002\u007f\u0003\u0007i\u0011a \u0006\u0004\u0003\u0003a\u0012!B7pI\u0016d\u0017bAA\u0003\u007f\n\tRI^1mk\u0006$\u0018n\u001c8D_:$X\r\u001f;\u0002\u0019A,(\r\\5tQ\u00163XM\u001c;\u0015\u0015\u0005-\u0011qBA\u0015\u0003w\ty\u0004F\u0002F\u0003\u001bAQ\u0001`\nA\u0004uDq!!\u0005\u0014\u0001\u0004\t\u0019\"\u0001\u0003lS:$\u0007\u0003BA\u000b\u0003GqA!a\u0006\u0002 A\u0019\u0011\u0011\u0004\u0015\u000e\u0005\u0005m!bAA\u000fI\u00051AH]8pizJ1!!\t)\u0003\u0019\u0001&/\u001a3fM&!\u0011QEA\u0014\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u0005\u0015\t\u000f\u0005-2\u00031\u0001\u0002.\u0005AAn\\2bi&|g\u000e\u0005\u0003\u00020\u0005]RBAA\u0019\u0015\u0011\tY#a\r\u000b\u0007\u0005UB$\u0001\u0004qCJ\u001cXM]\u0005\u0005\u0003s\t\tD\u0001\u0005M_\u000e\fG/[8o\u0011\u001d\tid\u0005a\u0001\u0003'\t!!\u001b3\t\u0013\u0005\u00053\u0003%AA\u0002\u0005\r\u0013\u0001\u00023bi\u0006\u0004RaJA#\u0003'I1!a\u0012)\u0005\u0015\t%O]1z\u0003Y\u0001XO\u00197jg\",e/\u001a8uI\u0011,g-Y;mi\u0012\"TCAA'U\u0011\t\u0019%a\u0014,\u0005\u0005E\u0003\u0003BA*\u0003;j!!!\u0016\u000b\t\u0005]\u0013\u0011L\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0017)\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003?\n)FA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQA\u001a7vg\"$\u0012!R\u0001\u0006G2|7/\u001a")
public class DefaultTelemetryService
implements TelemetryService {
    private Disruptor<DisruptorTelemetryEvent> disruptor;
    private RingBuffer<DisruptorTelemetryEvent> myRingBuffer;
    private TelemetryEventWriter eventWriter;
    private final IntervalExecutor bufferFullLogger = new IntervalExecutor(15L, TimeUnit.MINUTES);
    private volatile boolean initialized = false;

    private Disruptor<DisruptorTelemetryEvent> disruptor() {
        return this.disruptor;
    }

    private void disruptor_$eq(Disruptor<DisruptorTelemetryEvent> x$1) {
        this.disruptor = x$1;
    }

    private RingBuffer<DisruptorTelemetryEvent> myRingBuffer() {
        return this.myRingBuffer;
    }

    private void myRingBuffer_$eq(RingBuffer<DisruptorTelemetryEvent> x$1) {
        this.myRingBuffer = x$1;
    }

    private TelemetryEventWriter eventWriter() {
        return this.eventWriter;
    }

    private void eventWriter_$eq(TelemetryEventWriter x$1) {
        this.eventWriter = x$1;
    }

    private IntervalExecutor bufferFullLogger() {
        return this.bufferFullLogger;
    }

    private boolean initialized() {
        return this.initialized;
    }

    private void initialized_$eq(boolean x$1) {
        this.initialized = x$1;
    }

    public RingBuffer<DisruptorTelemetryEvent> ringBuffer() {
        return this.myRingBuffer();
    }

    public boolean isInitialized() {
        return this.initialized();
    }

    public void initIfRequired(EvaluationContext ctx) {
        if (!this.initialized()) {
            DefaultTelemetryService defaultTelemetryService = this;
            synchronized (defaultTelemetryService) {
                if (!this.initialized()) {
                    ServiceManager serviceManager = ctx.serviceManager();
                    ThreadFactory threadFactory = Executors.defaultThreadFactory();
                    DisruptorTelemetryEventFactory factory = new DisruptorTelemetryEventFactory();
                    SettingsService settings = ctx.serviceManager().settingsService();
                    int bufferSize = settings.telemetry().bufferSize();
                    this.disruptor_$eq((Disruptor<DisruptorTelemetryEvent>)new Disruptor((EventFactory)factory, bufferSize, threadFactory));
                    this.eventWriter_$eq(new FileTelemetryEventWriter(serviceManager.workingDirectoryService().telemetryDirectory()));
                    this.disruptor().handleEventsWith(new EventHandler[]{new TelemetryEventHandler(this.eventWriter())});
                    this.disruptor().start();
                    this.myRingBuffer_$eq((RingBuffer<DisruptorTelemetryEvent>)this.disruptor().getRingBuffer());
                    this.initialized_$eq(true);
                }
            }
        }
    }

    public void publishEvent(String kind, Location location, String id, String[] data, EvaluationContext ctx) {
        block2: {
            LoggingService loggingService;
            String locationString;
            long timeStamp;
            String threadId;
            block3: {
                String string;
                if (!ctx.serviceManager().settingsService().telemetry().enabled()) break block2;
                threadId = Thread.currentThread().getName();
                timeStamp = System.nanoTime();
                this.initIfRequired(ctx);
                Location location2 = location;
                if (location2 instanceof WeaveLocation) {
                    WeaveLocation weaveLocation = (WeaveLocation)location2;
                    string = weaveLocation.resourceWithLocation();
                } else {
                    string = "Unknown";
                }
                locationString = string;
                if (!ctx.serviceManager().settingsService().telemetry().sync()) break block3;
                this.eventWriter().write(kind, locationString, threadId, id, timeStamp, data);
                break block2;
            }
            boolean tryPublishEvent = this.myRingBuffer().tryPublishEvent((profilerEvent, sequence) -> {
                profilerEvent.kind_$eq(kind);
                profilerEvent.location_$eq(locationString);
                profilerEvent.threadId_$eq(threadId);
                profilerEvent.id_$eq(id);
                profilerEvent.timeStamp_$eq(timeStamp);
                profilerEvent.data_$eq(data);
            });
            if (tryPublishEvent || !(loggingService = ctx.serviceManager().loggingService()).isInfoEnabled()) break block2;
            this.bufferFullLogger().trigger((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> loggingService.logInfo(new StringBuilder(85).append("Ignoring event as the ring bugger is full. Consider increasing the buffer size with ").append(RuntimeSettings$.MODULE$.prop("telemetry.bufferSize")).append(" ").toString()));
        }
    }

    public String[] publishEvent$default$4() {
        return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
    }

    public void flush() {
        block0: {
            if (this.eventWriter() == null) break block0;
            this.disruptor().shutdown();
            this.eventWriter().flush();
        }
    }

    public void close() {
        block0: {
            if (this.eventWriter() == null) break block0;
            Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.disruptor().shutdown(10L, TimeUnit.SECONDS));
            this.eventWriter().close();
        }
    }
}

