package org.mule.weave.v2.helper

import java.io.File

import org.mule.weave.v2.parser.Message
import org.mule.weave.v2.parser.location.WeaveLocation
import org.scalactic.AbstractStringUniformity
import org.scalactic.Uniformity

import scala.io.Source.fromFile

trait BaseDataWeaveTest {

  val whiteSpaceNormalised: Uniformity[String] =
    new AbstractStringUniformity {

      /** Returns the string with all consecutive white spaces reduced to a single space. */
      def normalized(s: String): String = {
        val result: String = s.replaceAll("\\s+", " ").replaceAll(" ", "")
        result
      }

      override def toString: String = "whiteSpaceNormalised"
    }

  def shouldUpdateResult: Boolean = {
    java.lang.Boolean.getBoolean("updateResult")
  }

  def getTestCaseFolder(expectedFile: File): File = {
    val parts: Array[String] = getClass.getPackage.getName.split("\\.")
    val testCaseFolder = new File(expectedFile.getParentFile, s"../../../../${"../" * parts.length}src/test/resources/${parts.mkString("/")}")
    testCaseFolder
  }

  def fileToString(file: File): String = {
    val source = fromFile(file)
    try {
      source.mkString
    } finally {
      source.close()
    }

  }

  def dumpMessages(errorMessages: Seq[Message], warningMessages: Seq[Message]): String = {
    val writer = new JsonBuilder()
    writer.startObject()

    writer.key("errors")
    writer.startArray()
    errorMessages.foreach((m) => {
      writer.value(m.message)
    })
    writer.endArray()

    writer.key("warnings")
    writer.startArray()
    warningMessages.foreach((m) => {
      writer.value(m.message)
    })
    writer.endArray()

    writer.endObject()
    val content: String = writer.toString()
    content
  }

  def dumpLocatedMessages(errorMessages: Seq[(WeaveLocation, Message)], warningMessages: Seq[(WeaveLocation, Message)]): String = {
    val writer = new JsonBuilder()
    writer.startObject()

    writer.key("errors")
    writer.startArray()
    errorMessages.foreach((m) => {
      writer.startObject()
      writer.key("message").value(m._2.message)
      writer.key("location").value(m._1.startPosition.line + ":" + m._1.startPosition.column + "-" + m._1.endPosition.line + ":" + m._1.endPosition.column)
      writer.key("resource").value(m._1.resourceName.toString)
      writer.endObject()
    })
    writer.endArray()

    writer.key("warnings")
    writer.startArray()
    warningMessages.foreach((m) => {
      writer.startObject()
      writer.key("message").value(m._2.message)
      writer.key("location").value(m._1.startPosition.line + ":" + m._1.startPosition.column + "-" + m._1.endPosition.line + ":" + m._1.endPosition.column)
      writer.key("resource").value(m._1.resourceName.toString)
      writer.endObject()
    })
    writer.endArray()

    writer.endObject()
    val content: String = writer.toString()
    content
  }
}
